package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OriginRequestPolicyCookiesConfig(
    cookieBehavior: zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior,
    cookies: Optional[zio.aws.cloudfront.model.CookieNames] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookiesConfig = {
    import OriginRequestPolicyCookiesConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookiesConfig
      .builder()
      .cookieBehavior(cookieBehavior.unwrap)
      .optionallyWith(cookies.map(value => value.buildAwsValue()))(_.cookies)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig.ReadOnly =
    zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig
      .wrap(buildAwsValue())
}
object OriginRequestPolicyCookiesConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookiesConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig =
      zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig(
        cookieBehavior,
        cookies.map(value => value.asEditable)
      )
    def cookieBehavior
        : zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior
    def cookies: Optional[zio.aws.cloudfront.model.CookieNames.ReadOnly]
    def getCookieBehavior: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior
    ] = ZIO.succeed(cookieBehavior)
    def getCookies
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.CookieNames.ReadOnly] =
      AwsError.unwrapOptionField("cookies", cookies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookiesConfig
  ) extends zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig.ReadOnly {
    override val cookieBehavior
        : zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior =
      zio.aws.cloudfront.model.OriginRequestPolicyCookieBehavior
        .wrap(impl.cookieBehavior())
    override val cookies
        : Optional[zio.aws.cloudfront.model.CookieNames.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cookies())
        .map(value => zio.aws.cloudfront.model.CookieNames.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyCookiesConfig
  ): zio.aws.cloudfront.model.OriginRequestPolicyCookiesConfig.ReadOnly =
    new Wrapper(impl)
}
