package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateVpcOriginRequest(
    vpcOriginEndpointConfig: zio.aws.cloudfront.model.VpcOriginEndpointConfig,
    tags: Optional[zio.aws.cloudfront.model.Tags] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginRequest = {
    import CreateVpcOriginRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginRequest
      .builder()
      .vpcOriginEndpointConfig(vpcOriginEndpointConfig.buildAwsValue())
      .optionallyWith(tags.map(value => value.buildAwsValue()))(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateVpcOriginRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateVpcOriginRequest.wrap(buildAwsValue())
}
object CreateVpcOriginRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateVpcOriginRequest =
      zio.aws.cloudfront.model.CreateVpcOriginRequest(
        vpcOriginEndpointConfig.asEditable,
        tags.map(value => value.asEditable)
      )
    def vpcOriginEndpointConfig
        : zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly
    def tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly]
    def getVpcOriginEndpointConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly
    ] = ZIO.succeed(vpcOriginEndpointConfig)
    def getTags: ZIO[Any, AwsError, zio.aws.cloudfront.model.Tags.ReadOnly] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginRequest
  ) extends zio.aws.cloudfront.model.CreateVpcOriginRequest.ReadOnly {
    override val vpcOriginEndpointConfig
        : zio.aws.cloudfront.model.VpcOriginEndpointConfig.ReadOnly =
      zio.aws.cloudfront.model.VpcOriginEndpointConfig
        .wrap(impl.vpcOriginEndpointConfig())
    override val tags: Optional[zio.aws.cloudfront.model.Tags.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value => zio.aws.cloudfront.model.Tags.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateVpcOriginRequest
  ): zio.aws.cloudfront.model.CreateVpcOriginRequest.ReadOnly = new Wrapper(
    impl
  )
}
