package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateOriginRequestPolicyResponse(
    originRequestPolicy: Optional[
      zio.aws.cloudfront.model.OriginRequestPolicy
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse = {
    import UpdateOriginRequestPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse
      .builder()
      .optionallyWith(originRequestPolicy.map(value => value.buildAwsValue()))(
        _.originRequestPolicy
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse
      .wrap(buildAwsValue())
}
object UpdateOriginRequestPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse =
      zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse(
        originRequestPolicy.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def originRequestPolicy
        : Optional[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly]
    def eTag: Optional[String]
    def getOriginRequestPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("originRequestPolicy", originRequestPolicy)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse
  ) extends zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly {
    override val originRequestPolicy
        : Optional[zio.aws.cloudfront.model.OriginRequestPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originRequestPolicy())
        .map(value => zio.aws.cloudfront.model.OriginRequestPolicy.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse
  ): zio.aws.cloudfront.model.UpdateOriginRequestPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
