package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKeyGroupsRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest = {
    import ListKeyGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.ListKeyGroupsRequest.ReadOnly =
    zio.aws.cloudfront.model.ListKeyGroupsRequest.wrap(buildAwsValue())
}
object ListKeyGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.ListKeyGroupsRequest =
      zio.aws.cloudfront.model.ListKeyGroupsRequest(
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def marker: Optional[String]
    def maxItems: Optional[String]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest
  ) extends zio.aws.cloudfront.model.ListKeyGroupsRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest
  ): zio.aws.cloudfront.model.ListKeyGroupsRequest.ReadOnly = new Wrapper(impl)
}
