package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.KeyValueStoreARN
import scala.jdk.CollectionConverters._
final case class KeyValueStoreAssociation(keyValueStoreARN: KeyValueStoreARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociation = {
    import KeyValueStoreAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociation
      .builder()
      .keyValueStoreARN(
        KeyValueStoreARN.unwrap(keyValueStoreARN): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.KeyValueStoreAssociation.ReadOnly =
    zio.aws.cloudfront.model.KeyValueStoreAssociation.wrap(buildAwsValue())
}
object KeyValueStoreAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.KeyValueStoreAssociation =
      zio.aws.cloudfront.model.KeyValueStoreAssociation(keyValueStoreARN)
    def keyValueStoreARN: KeyValueStoreARN
    def getKeyValueStoreARN: ZIO[Any, Nothing, KeyValueStoreARN] =
      ZIO.succeed(keyValueStoreARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociation
  ) extends zio.aws.cloudfront.model.KeyValueStoreAssociation.ReadOnly {
    override val keyValueStoreARN: KeyValueStoreARN =
      zio.aws.cloudfront.model.primitives
        .KeyValueStoreARN(impl.keyValueStoreARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.KeyValueStoreAssociation
  ): zio.aws.cloudfront.model.KeyValueStoreAssociation.ReadOnly = new Wrapper(
    impl
  )
}
