package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VpcOriginConfig(
    vpcOriginId: String,
    originReadTimeout: Optional[Integer] = Optional.Absent,
    originKeepaliveTimeout: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.VpcOriginConfig = {
    import VpcOriginConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.VpcOriginConfig
      .builder()
      .vpcOriginId(vpcOriginId: java.lang.String)
      .optionallyWith(originReadTimeout.map(value => value: java.lang.Integer))(
        _.originReadTimeout
      )
      .optionallyWith(
        originKeepaliveTimeout.map(value => value: java.lang.Integer)
      )(_.originKeepaliveTimeout)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.VpcOriginConfig.ReadOnly =
    zio.aws.cloudfront.model.VpcOriginConfig.wrap(buildAwsValue())
}
object VpcOriginConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.VpcOriginConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.VpcOriginConfig =
      zio.aws.cloudfront.model.VpcOriginConfig(
        vpcOriginId,
        originReadTimeout.map(value => value),
        originKeepaliveTimeout.map(value => value)
      )
    def vpcOriginId: String
    def originReadTimeout: Optional[Integer]
    def originKeepaliveTimeout: Optional[Integer]
    def getVpcOriginId: ZIO[Any, Nothing, String] = ZIO.succeed(vpcOriginId)
    def getOriginReadTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("originReadTimeout", originReadTimeout)
    def getOriginKeepaliveTimeout: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("originKeepaliveTimeout", originKeepaliveTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.VpcOriginConfig
  ) extends zio.aws.cloudfront.model.VpcOriginConfig.ReadOnly {
    override val vpcOriginId: String = impl.vpcOriginId(): String
    override val originReadTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.originReadTimeout())
      .map(value => value: Integer)
    override val originKeepaliveTimeout: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originKeepaliveTimeout())
        .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.VpcOriginConfig
  ): zio.aws.cloudfront.model.VpcOriginConfig.ReadOnly = new Wrapper(impl)
}
