package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublicKeyConfig(
    callerReference: String,
    name: String,
    encodedKey: String,
    comment: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.PublicKeyConfig = {
    import PublicKeyConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.PublicKeyConfig
      .builder()
      .callerReference(callerReference: java.lang.String)
      .name(name: java.lang.String)
      .encodedKey(encodedKey: java.lang.String)
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly =
    zio.aws.cloudfront.model.PublicKeyConfig.wrap(buildAwsValue())
}
object PublicKeyConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.PublicKeyConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.PublicKeyConfig =
      zio.aws.cloudfront.model.PublicKeyConfig(
        callerReference,
        name,
        encodedKey,
        comment.map(value => value)
      )
    def callerReference: String
    def name: String
    def encodedKey: String
    def comment: Optional[String]
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getEncodedKey: ZIO[Any, Nothing, String] = ZIO.succeed(encodedKey)
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.PublicKeyConfig
  ) extends zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly {
    override val callerReference: String = impl.callerReference(): String
    override val name: String = impl.name(): String
    override val encodedKey: String = impl.encodedKey(): String
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.PublicKeyConfig
  ): zio.aws.cloudfront.model.PublicKeyConfig.ReadOnly = new Wrapper(impl)
}
