package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDistributionResponse(
    distribution: Optional[zio.aws.cloudfront.model.Distribution] =
      Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse = {
    import GetDistributionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse
      .builder()
      .optionallyWith(distribution.map(value => value.buildAwsValue()))(
        _.distribution
      )
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.GetDistributionResponse.ReadOnly =
    zio.aws.cloudfront.model.GetDistributionResponse.wrap(buildAwsValue())
}
object GetDistributionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetDistributionResponse =
      zio.aws.cloudfront.model.GetDistributionResponse(
        distribution.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def distribution: Optional[zio.aws.cloudfront.model.Distribution.ReadOnly]
    def eTag: Optional[String]
    def getDistribution
        : ZIO[Any, AwsError, zio.aws.cloudfront.model.Distribution.ReadOnly] =
      AwsError.unwrapOptionField("distribution", distribution)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse
  ) extends zio.aws.cloudfront.model.GetDistributionResponse.ReadOnly {
    override val distribution
        : Optional[zio.aws.cloudfront.model.Distribution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.distribution())
        .map(value => zio.aws.cloudfront.model.Distribution.wrap(value))
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse
  ): zio.aws.cloudfront.model.GetDistributionResponse.ReadOnly = new Wrapper(
    impl
  )
}
