package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.{
  Timestamp,
  Integer,
  AnycastIpListName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class AnycastIpListSummary(
    id: String,
    name: AnycastIpListName,
    status: String,
    arn: String,
    ipCount: Integer,
    lastModifiedTime: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary = {
    import AnycastIpListSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary
      .builder()
      .id(id: java.lang.String)
      .name(AnycastIpListName.unwrap(name): java.lang.String)
      .status(status: java.lang.String)
      .arn(arn: java.lang.String)
      .ipCount(ipCount: java.lang.Integer)
      .lastModifiedTime(Timestamp.unwrap(lastModifiedTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.AnycastIpListSummary.ReadOnly =
    zio.aws.cloudfront.model.AnycastIpListSummary.wrap(buildAwsValue())
}
object AnycastIpListSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.AnycastIpListSummary =
      zio.aws.cloudfront.model.AnycastIpListSummary(
        id,
        name,
        status,
        arn,
        ipCount,
        lastModifiedTime
      )
    def id: String
    def name: AnycastIpListName
    def status: String
    def arn: String
    def ipCount: Integer
    def lastModifiedTime: Timestamp
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, AnycastIpListName] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getArn: ZIO[Any, Nothing, String] = ZIO.succeed(arn)
    def getIpCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(ipCount)
    def getLastModifiedTime: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary
  ) extends zio.aws.cloudfront.model.AnycastIpListSummary.ReadOnly {
    override val id: String = impl.id(): String
    override val name: AnycastIpListName =
      zio.aws.cloudfront.model.primitives.AnycastIpListName(impl.name())
    override val status: String = impl.status(): String
    override val arn: String = impl.arn(): String
    override val ipCount: Integer = impl.ipCount(): Integer
    override val lastModifiedTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.lastModifiedTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.AnycastIpListSummary
  ): zio.aws.cloudfront.model.AnycastIpListSummary.ReadOnly = new Wrapper(impl)
}
