package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait FunctionStage {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.FunctionStage
}
object FunctionStage {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.FunctionStage
  ): zio.aws.cloudfront.model.FunctionStage = value match {
    case software.amazon.awssdk.services.cloudfront.model.FunctionStage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.FunctionStage.DEVELOPMENT =>
      val r = DEVELOPMENT
      r
    case software.amazon.awssdk.services.cloudfront.model.FunctionStage.LIVE =>
      val r = LIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.FunctionStage {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.FunctionStage =
      software.amazon.awssdk.services.cloudfront.model.FunctionStage.UNKNOWN_TO_SDK_VERSION
  }
  case object DEVELOPMENT extends zio.aws.cloudfront.model.FunctionStage {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.FunctionStage =
      software.amazon.awssdk.services.cloudfront.model.FunctionStage.DEVELOPMENT
  }
  case object LIVE extends zio.aws.cloudfront.model.FunctionStage {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.FunctionStage =
      software.amazon.awssdk.services.cloudfront.model.FunctionStage.LIVE
  }
}
