package zio.aws.cloudfront
import zio.aws.cloudfront.model.primitives.TagKey.Type
import java.time.Instant
import zio.aws.cloudfront.model.primitives.{TagKey, Integer}
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AliasString extends zio.prelude.Subtype[String]
    type AliasString = zio.aws.cloudfront.model.primitives.AliasString.Type
    object AnycastIpListName extends zio.prelude.Subtype[String]
    type AnycastIpListName =
      zio.aws.cloudfront.model.primitives.AnycastIpListName.Type
    object CommentType extends zio.prelude.Subtype[String]
    type CommentType = zio.aws.cloudfront.model.primitives.CommentType.Type
    object DistributionIdString extends zio.prelude.Subtype[String]
    type DistributionIdString =
      zio.aws.cloudfront.model.primitives.DistributionIdString.Type
    object FunctionARN extends zio.prelude.Subtype[String]
    type FunctionARN = zio.aws.cloudfront.model.primitives.FunctionARN.Type
    object FunctionBlob extends zio.prelude.Subtype[Chunk[Byte]]
    type FunctionBlob = zio.aws.cloudfront.model.primitives.FunctionBlob.Type
    object FunctionEventObject extends zio.prelude.Subtype[Chunk[Byte]]
    type FunctionEventObject =
      zio.aws.cloudfront.model.primitives.FunctionEventObject.Type
    object FunctionName extends zio.prelude.Subtype[String]
    type FunctionName = zio.aws.cloudfront.model.primitives.FunctionName.Type
    type Integer = Int
    object KeyValueStoreARN extends zio.prelude.Subtype[String]
    type KeyValueStoreARN =
      zio.aws.cloudfront.model.primitives.KeyValueStoreARN.Type
    object KeyValueStoreComment extends zio.prelude.Subtype[String]
    type KeyValueStoreComment =
      zio.aws.cloudfront.model.primitives.KeyValueStoreComment.Type
    object KeyValueStoreName extends zio.prelude.Subtype[String]
    type KeyValueStoreName =
      zio.aws.cloudfront.model.primitives.KeyValueStoreName.Type
    object LambdaFunctionARN extends zio.prelude.Subtype[String]
    type LambdaFunctionARN =
      zio.aws.cloudfront.model.primitives.LambdaFunctionARN.Type
    object ListConflictingAliasesMaxItemsInteger
        extends zio.prelude.Subtype[Int]
    type ListConflictingAliasesMaxItemsInteger =
      zio.aws.cloudfront.model.primitives.ListConflictingAliasesMaxItemsInteger.Type
    object OriginShieldRegion extends zio.prelude.Subtype[String]
    type OriginShieldRegion =
      zio.aws.cloudfront.model.primitives.OriginShieldRegion.Type
    object ResourceARN extends zio.prelude.Subtype[String]
    type ResourceARN = zio.aws.cloudfront.model.primitives.ResourceARN.Type
    object SamplingRate extends zio.prelude.Subtype[Double]
    type SamplingRate = zio.aws.cloudfront.model.primitives.SamplingRate.Type
    object SensitiveStringType extends zio.prelude.Subtype[String]
    type SensitiveStringType =
      zio.aws.cloudfront.model.primitives.SensitiveStringType.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.cloudfront.model.primitives.TagKey.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.cloudfront.model.primitives.TagValue.Type
    object Timestamp extends zio.prelude.Subtype[Instant]
    type Timestamp = zio.aws.cloudfront.model.primitives.Timestamp.Type
  }
  type AccessControlAllowHeadersList = List[String]
  type AccessControlAllowMethodsList = List[
    zio.aws.cloudfront.model.ResponseHeadersPolicyAccessControlAllowMethodsValues
  ]
  type AccessControlAllowOriginsList = List[String]
  type AccessControlExposeHeadersList = List[String]
  type AliasICPRecordals = List[zio.aws.cloudfront.model.AliasICPRecordal]
  type AliasList = List[String]
  type AnycastIpListSummaries =
    List[zio.aws.cloudfront.model.AnycastIpListSummary]
  type AnycastIps = List[String]
  type AwsAccountNumberList = List[String]
  type CacheBehaviorList = List[zio.aws.cloudfront.model.CacheBehavior]
  type CachePolicySummaryList =
    List[zio.aws.cloudfront.model.CachePolicySummary]
  type CloudFrontOriginAccessIdentitySummaryList =
    List[zio.aws.cloudfront.model.CloudFrontOriginAccessIdentitySummary]
  type ConflictingAliases = List[zio.aws.cloudfront.model.ConflictingAlias]
  type ContentTypeProfileList =
    List[zio.aws.cloudfront.model.ContentTypeProfile]
  type ContinuousDeploymentPolicySummaryList =
    List[zio.aws.cloudfront.model.ContinuousDeploymentPolicySummary]
  type CookieNameList = List[String]
  type CustomErrorResponseList =
    List[zio.aws.cloudfront.model.CustomErrorResponse]
  type DistributionIdListSummary = List[String]
  type DistributionSummaryList =
    List[zio.aws.cloudfront.model.DistributionSummary]
  type EncryptionEntityList = List[zio.aws.cloudfront.model.EncryptionEntity]
  type EndPointList = List[zio.aws.cloudfront.model.EndPoint]
  type FieldLevelEncryptionProfileSummaryList =
    List[zio.aws.cloudfront.model.FieldLevelEncryptionProfileSummary]
  type FieldLevelEncryptionSummaryList =
    List[zio.aws.cloudfront.model.FieldLevelEncryptionSummary]
  type FieldList = List[String]
  type FieldPatternList = List[String]
  type FunctionAssociationList =
    List[zio.aws.cloudfront.model.FunctionAssociation]
  type FunctionExecutionLogList = List[String]
  type FunctionSummaryList = List[zio.aws.cloudfront.model.FunctionSummary]
  type HeaderList = List[String]
  type InvalidationSummaryList =
    List[zio.aws.cloudfront.model.InvalidationSummary]
  type KGKeyPairIdsList = List[zio.aws.cloudfront.model.KGKeyPairIds]
  type KeyGroupSummaryList = List[zio.aws.cloudfront.model.KeyGroupSummary]
  type KeyPairIdList = List[String]
  type KeyValueStoreAssociationList =
    List[zio.aws.cloudfront.model.KeyValueStoreAssociation]
  type KeyValueStoreSummaryList = List[zio.aws.cloudfront.model.KeyValueStore]
  type LambdaFunctionAssociationList =
    List[zio.aws.cloudfront.model.LambdaFunctionAssociation]
  type LocationList = List[String]
  type MethodsList = List[zio.aws.cloudfront.model.Method]
  type OriginAccessControlSummaryList =
    List[zio.aws.cloudfront.model.OriginAccessControlSummary]
  type OriginCustomHeadersList =
    List[zio.aws.cloudfront.model.OriginCustomHeader]
  type OriginGroupList = List[zio.aws.cloudfront.model.OriginGroup]
  type OriginGroupMemberList = List[zio.aws.cloudfront.model.OriginGroupMember]
  type OriginList = List[zio.aws.cloudfront.model.Origin]
  type OriginRequestPolicySummaryList =
    List[zio.aws.cloudfront.model.OriginRequestPolicySummary]
  type PathList = List[String]
  type PublicKeyIdList = List[String]
  type PublicKeySummaryList = List[zio.aws.cloudfront.model.PublicKeySummary]
  type QueryArgProfileList = List[zio.aws.cloudfront.model.QueryArgProfile]
  type QueryStringCacheKeysList = List[String]
  type QueryStringNamesList = List[String]
  type RealtimeLogConfigList = List[zio.aws.cloudfront.model.RealtimeLogConfig]
  type ResponseHeadersPolicyCustomHeaderList =
    List[zio.aws.cloudfront.model.ResponseHeadersPolicyCustomHeader]
  type ResponseHeadersPolicyRemoveHeaderList =
    List[zio.aws.cloudfront.model.ResponseHeadersPolicyRemoveHeader]
  type ResponseHeadersPolicySummaryList =
    List[zio.aws.cloudfront.model.ResponseHeadersPolicySummary]
  type SignerList = List[zio.aws.cloudfront.model.Signer]
  type SslProtocolsList = List[zio.aws.cloudfront.model.SslProtocol]
  type StagingDistributionDnsNameList = List[String]
  type StatusCodeList = List[Integer]
  type StreamingDistributionSummaryList =
    List[zio.aws.cloudfront.model.StreamingDistributionSummary]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.cloudfront.model.Tag]
  type TrustedKeyGroupIdList = List[String]
  type VpcOriginSummaryList = List[zio.aws.cloudfront.model.VpcOriginSummary]
}
