package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait OriginGroupSelectionCriteria {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria
}
object OriginGroupSelectionCriteria {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria
  ): zio.aws.cloudfront.model.OriginGroupSelectionCriteria = value match {
    case software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria.DEFAULT =>
      val r = default
      r
    case software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria.MEDIA_QUALITY_BASED =>
      val r = `media-quality-based`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.OriginGroupSelectionCriteria {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria =
      software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria.UNKNOWN_TO_SDK_VERSION
  }
  case object default
      extends zio.aws.cloudfront.model.OriginGroupSelectionCriteria {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria =
      software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria.DEFAULT
  }
  case object `media-quality-based`
      extends zio.aws.cloudfront.model.OriginGroupSelectionCriteria {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria =
      software.amazon.awssdk.services.cloudfront.model.OriginGroupSelectionCriteria.MEDIA_QUALITY_BASED
  }
}
