package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OriginGroup(
    id: String,
    failoverCriteria: zio.aws.cloudfront.model.OriginGroupFailoverCriteria,
    members: zio.aws.cloudfront.model.OriginGroupMembers,
    selectionCriteria: Optional[
      zio.aws.cloudfront.model.OriginGroupSelectionCriteria
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.OriginGroup = {
    import OriginGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.OriginGroup
      .builder()
      .id(id: java.lang.String)
      .failoverCriteria(failoverCriteria.buildAwsValue())
      .members(members.buildAwsValue())
      .optionallyWith(selectionCriteria.map(value => value.unwrap))(
        _.selectionCriteria
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.OriginGroup.ReadOnly =
    zio.aws.cloudfront.model.OriginGroup.wrap(buildAwsValue())
}
object OriginGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.OriginGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.OriginGroup =
      zio.aws.cloudfront.model.OriginGroup(
        id,
        failoverCriteria.asEditable,
        members.asEditable,
        selectionCriteria.map(value => value)
      )
    def id: String
    def failoverCriteria
        : zio.aws.cloudfront.model.OriginGroupFailoverCriteria.ReadOnly
    def members: zio.aws.cloudfront.model.OriginGroupMembers.ReadOnly
    def selectionCriteria
        : Optional[zio.aws.cloudfront.model.OriginGroupSelectionCriteria]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getFailoverCriteria: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginGroupFailoverCriteria.ReadOnly
    ] = ZIO.succeed(failoverCriteria)
    def getMembers: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.OriginGroupMembers.ReadOnly
    ] = ZIO.succeed(members)
    def getSelectionCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.OriginGroupSelectionCriteria
    ] = AwsError.unwrapOptionField("selectionCriteria", selectionCriteria)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroup
  ) extends zio.aws.cloudfront.model.OriginGroup.ReadOnly {
    override val id: String = impl.id(): String
    override val failoverCriteria
        : zio.aws.cloudfront.model.OriginGroupFailoverCriteria.ReadOnly =
      zio.aws.cloudfront.model.OriginGroupFailoverCriteria
        .wrap(impl.failoverCriteria())
    override val members: zio.aws.cloudfront.model.OriginGroupMembers.ReadOnly =
      zio.aws.cloudfront.model.OriginGroupMembers.wrap(impl.members())
    override val selectionCriteria
        : Optional[zio.aws.cloudfront.model.OriginGroupSelectionCriteria] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selectionCriteria())
        .map(value =>
          zio.aws.cloudfront.model.OriginGroupSelectionCriteria.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.OriginGroup
  ): zio.aws.cloudfront.model.OriginGroup.ReadOnly = new Wrapper(impl)
}
