package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListContinuousDeploymentPoliciesRequest(
    marker: Optional[String] = Optional.Absent,
    maxItems: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest = {
    import ListContinuousDeploymentPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(maxItems.map(value => value: java.lang.String))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesRequest.ReadOnly =
    zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesRequest
      .wrap(buildAwsValue())
}
object ListContinuousDeploymentPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesRequest =
      zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesRequest(
        marker.map(value => value),
        maxItems.map(value => value)
      )
    def marker: Optional[String]
    def maxItems: Optional[String]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest
  ) extends zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesRequest.ReadOnly {
    override val marker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => value: String)
    override val maxItems: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest
  ): zio.aws.cloudfront.model.ListContinuousDeploymentPoliciesRequest.ReadOnly =
    new Wrapper(impl)
}
