package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetFieldLevelEncryptionProfileResponse(
    fieldLevelEncryptionProfile: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse = {
    import GetFieldLevelEncryptionProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse
      .builder()
      .optionallyWith(
        fieldLevelEncryptionProfile.map(value => value.buildAwsValue())
      )(_.fieldLevelEncryptionProfile)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse.ReadOnly =
    zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse
      .wrap(buildAwsValue())
}
object GetFieldLevelEncryptionProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse =
      zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse(
        fieldLevelEncryptionProfile.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def fieldLevelEncryptionProfile: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ]
    def eTag: Optional[String]
    def getFieldLevelEncryptionProfile: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fieldLevelEncryptionProfile",
      fieldLevelEncryptionProfile
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse
  ) extends zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse.ReadOnly {
    override val fieldLevelEncryptionProfile: Optional[
      zio.aws.cloudfront.model.FieldLevelEncryptionProfile.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fieldLevelEncryptionProfile())
      .map(value =>
        zio.aws.cloudfront.model.FieldLevelEncryptionProfile.wrap(value)
      )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse
  ): zio.aws.cloudfront.model.GetFieldLevelEncryptionProfileResponse.ReadOnly =
    new Wrapper(impl)
}
