package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FieldLevelEncryptionProfileConfig(
    name: String,
    callerReference: String,
    comment: Optional[String] = Optional.Absent,
    encryptionEntities: zio.aws.cloudfront.model.EncryptionEntities
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileConfig = {
    import FieldLevelEncryptionProfileConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileConfig
      .builder()
      .name(name: java.lang.String)
      .callerReference(callerReference: java.lang.String)
      .optionallyWith(comment.map(value => value: java.lang.String))(_.comment)
      .encryptionEntities(encryptionEntities.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly =
    zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig
      .wrap(buildAwsValue())
}
object FieldLevelEncryptionProfileConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig =
      zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig(
        name,
        callerReference,
        comment.map(value => value),
        encryptionEntities.asEditable
      )
    def name: String
    def callerReference: String
    def comment: Optional[String]
    def encryptionEntities: zio.aws.cloudfront.model.EncryptionEntities.ReadOnly
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getCallerReference: ZIO[Any, Nothing, String] =
      ZIO.succeed(callerReference)
    def getComment: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("comment", comment)
    def getEncryptionEntities: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.EncryptionEntities.ReadOnly
    ] = ZIO.succeed(encryptionEntities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileConfig
  ) extends zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly {
    override val name: String = impl.name(): String
    override val callerReference: String = impl.callerReference(): String
    override val comment: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => value: String)
    override val encryptionEntities
        : zio.aws.cloudfront.model.EncryptionEntities.ReadOnly =
      zio.aws.cloudfront.model.EncryptionEntities
        .wrap(impl.encryptionEntities())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileConfig
  ): zio.aws.cloudfront.model.FieldLevelEncryptionProfileConfig.ReadOnly =
    new Wrapper(impl)
}
