package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteStreamingDistributionRequest(
    id: String,
    ifMatch: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest = {
    import DeleteStreamingDistributionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(ifMatch.map(value => value: java.lang.String))(_.ifMatch)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.DeleteStreamingDistributionRequest.ReadOnly =
    zio.aws.cloudfront.model.DeleteStreamingDistributionRequest
      .wrap(buildAwsValue())
}
object DeleteStreamingDistributionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.DeleteStreamingDistributionRequest =
      zio.aws.cloudfront.model
        .DeleteStreamingDistributionRequest(id, ifMatch.map(value => value))
    def id: String
    def ifMatch: Optional[String]
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getIfMatch: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ifMatch", ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest
  ) extends zio.aws.cloudfront.model.DeleteStreamingDistributionRequest.ReadOnly {
    override val id: String = impl.id(): String
    override val ifMatch: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ifMatch())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest
  ): zio.aws.cloudfront.model.DeleteStreamingDistributionRequest.ReadOnly =
    new Wrapper(impl)
}
