package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.{
  KeyValueStoreComment,
  KeyValueStoreName
}
import scala.jdk.CollectionConverters._
final case class UpdateKeyValueStoreRequest(
    name: KeyValueStoreName,
    comment: KeyValueStoreComment,
    ifMatch: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.UpdateKeyValueStoreRequest = {
    import UpdateKeyValueStoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.UpdateKeyValueStoreRequest
      .builder()
      .name(KeyValueStoreName.unwrap(name): java.lang.String)
      .comment(KeyValueStoreComment.unwrap(comment): java.lang.String)
      .ifMatch(ifMatch: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.UpdateKeyValueStoreRequest.ReadOnly =
    zio.aws.cloudfront.model.UpdateKeyValueStoreRequest.wrap(buildAwsValue())
}
object UpdateKeyValueStoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.UpdateKeyValueStoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.UpdateKeyValueStoreRequest =
      zio.aws.cloudfront.model
        .UpdateKeyValueStoreRequest(name, comment, ifMatch)
    def name: KeyValueStoreName
    def comment: KeyValueStoreComment
    def ifMatch: String
    def getName: ZIO[Any, Nothing, KeyValueStoreName] = ZIO.succeed(name)
    def getComment: ZIO[Any, Nothing, KeyValueStoreComment] =
      ZIO.succeed(comment)
    def getIfMatch: ZIO[Any, Nothing, String] = ZIO.succeed(ifMatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateKeyValueStoreRequest
  ) extends zio.aws.cloudfront.model.UpdateKeyValueStoreRequest.ReadOnly {
    override val name: KeyValueStoreName =
      zio.aws.cloudfront.model.primitives.KeyValueStoreName(impl.name())
    override val comment: KeyValueStoreComment =
      zio.aws.cloudfront.model.primitives.KeyValueStoreComment(impl.comment())
    override val ifMatch: String = impl.ifMatch(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.UpdateKeyValueStoreRequest
  ): zio.aws.cloudfront.model.UpdateKeyValueStoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
