package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.cloudfront.model.primitives.Integer
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PublicKeyList(
    nextMarker: Optional[String] = Optional.Absent,
    maxItems: Integer,
    quantity: Integer,
    items: Optional[Iterable[zio.aws.cloudfront.model.PublicKeySummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.PublicKeyList = {
    import PublicKeyList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.PublicKeyList
      .builder()
      .optionallyWith(nextMarker.map(value => value: java.lang.String))(
        _.nextMarker
      )
      .maxItems(maxItems: java.lang.Integer)
      .quantity(quantity: java.lang.Integer)
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.items)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.PublicKeyList.ReadOnly =
    zio.aws.cloudfront.model.PublicKeyList.wrap(buildAwsValue())
}
object PublicKeyList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.PublicKeyList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.PublicKeyList =
      zio.aws.cloudfront.model.PublicKeyList(
        nextMarker.map(value => value),
        maxItems,
        quantity,
        items.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[String]
    def maxItems: Integer
    def quantity: Integer
    def items
        : Optional[List[zio.aws.cloudfront.model.PublicKeySummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getMaxItems: ZIO[Any, Nothing, Integer] = ZIO.succeed(maxItems)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getItems: ZIO[Any, AwsError, List[
      zio.aws.cloudfront.model.PublicKeySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("items", items)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.PublicKeyList
  ) extends zio.aws.cloudfront.model.PublicKeyList.ReadOnly {
    override val nextMarker: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => value: String)
    override val maxItems: Integer = impl.maxItems(): Integer
    override val quantity: Integer = impl.quantity(): Integer
    override val items
        : Optional[List[zio.aws.cloudfront.model.PublicKeySummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.items())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudfront.model.PublicKeySummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.PublicKeyList
  ): zio.aws.cloudfront.model.PublicKeyList.ReadOnly = new Wrapper(impl)
}
