package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateCachePolicyRequest(
    cachePolicyConfig: zio.aws.cloudfront.model.CachePolicyConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest = {
    import CreateCachePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest
      .builder()
      .cachePolicyConfig(cachePolicyConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.CreateCachePolicyRequest.ReadOnly =
    zio.aws.cloudfront.model.CreateCachePolicyRequest.wrap(buildAwsValue())
}
object CreateCachePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.CreateCachePolicyRequest =
      zio.aws.cloudfront.model
        .CreateCachePolicyRequest(cachePolicyConfig.asEditable)
    def cachePolicyConfig: zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly
    def getCachePolicyConfig: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly
    ] = ZIO.succeed(cachePolicyConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest
  ) extends zio.aws.cloudfront.model.CreateCachePolicyRequest.ReadOnly {
    override val cachePolicyConfig
        : zio.aws.cloudfront.model.CachePolicyConfig.ReadOnly =
      zio.aws.cloudfront.model.CachePolicyConfig.wrap(impl.cachePolicyConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest
  ): zio.aws.cloudfront.model.CreateCachePolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
