package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class SessionStickinessConfig(
    idleTTL: Integer,
    maximumTTL: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.SessionStickinessConfig = {
    import SessionStickinessConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.SessionStickinessConfig
      .builder()
      .idleTTL(idleTTL: java.lang.Integer)
      .maximumTTL(maximumTTL: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.SessionStickinessConfig.ReadOnly =
    zio.aws.cloudfront.model.SessionStickinessConfig.wrap(buildAwsValue())
}
object SessionStickinessConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.SessionStickinessConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.SessionStickinessConfig =
      zio.aws.cloudfront.model.SessionStickinessConfig(idleTTL, maximumTTL)
    def idleTTL: Integer
    def maximumTTL: Integer
    def getIdleTTL: ZIO[Any, Nothing, Integer] = ZIO.succeed(idleTTL)
    def getMaximumTTL: ZIO[Any, Nothing, Integer] = ZIO.succeed(maximumTTL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.SessionStickinessConfig
  ) extends zio.aws.cloudfront.model.SessionStickinessConfig.ReadOnly {
    override val idleTTL: Integer = impl.idleTTL(): Integer
    override val maximumTTL: Integer = impl.maximumTTL(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.SessionStickinessConfig
  ): zio.aws.cloudfront.model.SessionStickinessConfig.ReadOnly = new Wrapper(
    impl
  )
}
