package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class S3OriginConfig(originAccessIdentity: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.S3OriginConfig = {
    import S3OriginConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.S3OriginConfig
      .builder()
      .originAccessIdentity(originAccessIdentity: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.S3OriginConfig.ReadOnly =
    zio.aws.cloudfront.model.S3OriginConfig.wrap(buildAwsValue())
}
object S3OriginConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.S3OriginConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.S3OriginConfig =
      zio.aws.cloudfront.model.S3OriginConfig(originAccessIdentity)
    def originAccessIdentity: String
    def getOriginAccessIdentity: ZIO[Any, Nothing, String] =
      ZIO.succeed(originAccessIdentity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.S3OriginConfig
  ) extends zio.aws.cloudfront.model.S3OriginConfig.ReadOnly {
    override val originAccessIdentity: String =
      impl.originAccessIdentity(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.S3OriginConfig
  ): zio.aws.cloudfront.model.S3OriginConfig.ReadOnly = new Wrapper(impl)
}
