package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetResponseHeadersPolicyResponse(
    responseHeadersPolicy: Optional[
      zio.aws.cloudfront.model.ResponseHeadersPolicy
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse = {
    import GetResponseHeadersPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse
      .builder()
      .optionallyWith(
        responseHeadersPolicy.map(value => value.buildAwsValue())
      )(_.responseHeadersPolicy)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse
      .wrap(buildAwsValue())
}
object GetResponseHeadersPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse =
      zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse(
        responseHeadersPolicy.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def responseHeadersPolicy
        : Optional[zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly]
    def eTag: Optional[String]
    def getResponseHeadersPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly
    ] =
      AwsError.unwrapOptionField("responseHeadersPolicy", responseHeadersPolicy)
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse
  ) extends zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly {
    override val responseHeadersPolicy
        : Optional[zio.aws.cloudfront.model.ResponseHeadersPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseHeadersPolicy())
        .map(value =>
          zio.aws.cloudfront.model.ResponseHeadersPolicy.wrap(value)
        )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse
  ): zio.aws.cloudfront.model.GetResponseHeadersPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
