package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContinuousDeploymentPolicyResponse(
    continuousDeploymentPolicy: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicy
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyResponse = {
    import GetContinuousDeploymentPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyResponse
      .builder()
      .optionallyWith(
        continuousDeploymentPolicy.map(value => value.buildAwsValue())
      )(_.continuousDeploymentPolicy)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse.ReadOnly =
    zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse
      .wrap(buildAwsValue())
}
object GetContinuousDeploymentPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse =
      zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse(
        continuousDeploymentPolicy.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def continuousDeploymentPolicy
        : Optional[zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly]
    def eTag: Optional[String]
    def getContinuousDeploymentPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continuousDeploymentPolicy",
      continuousDeploymentPolicy
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyResponse
  ) extends zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse.ReadOnly {
    override val continuousDeploymentPolicy: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicy.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.continuousDeploymentPolicy())
      .map(value =>
        zio.aws.cloudfront.model.ContinuousDeploymentPolicy.wrap(value)
      )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyResponse
  ): zio.aws.cloudfront.model.GetContinuousDeploymentPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
