package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait OriginAccessControlSigningBehaviors {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors
}
object OriginAccessControlSigningBehaviors {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors
  ): zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors =
    value match {
      case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors.NEVER =>
        val r = never
        r
      case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors.ALWAYS =>
        val r = always
        r
      case software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors.NO_OVERRIDE =>
        val r = `no-override`
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors.UNKNOWN_TO_SDK_VERSION
  }
  case object never
      extends zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors.NEVER
  }
  case object always
      extends zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors.ALWAYS
  }
  case object `no-override`
      extends zio.aws.cloudfront.model.OriginAccessControlSigningBehaviors {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors =
      software.amazon.awssdk.services.cloudfront.model.OriginAccessControlSigningBehaviors.NO_OVERRIDE
  }
}
