package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MonitoringSubscription(
    realtimeMetricsSubscriptionConfig: Optional[
      zio.aws.cloudfront.model.RealtimeMetricsSubscriptionConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.MonitoringSubscription = {
    import MonitoringSubscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.MonitoringSubscription
      .builder()
      .optionallyWith(
        realtimeMetricsSubscriptionConfig.map(value => value.buildAwsValue())
      )(_.realtimeMetricsSubscriptionConfig)
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly =
    zio.aws.cloudfront.model.MonitoringSubscription.wrap(buildAwsValue())
}
object MonitoringSubscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.MonitoringSubscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.MonitoringSubscription =
      zio.aws.cloudfront.model.MonitoringSubscription(
        realtimeMetricsSubscriptionConfig.map(value => value.asEditable)
      )
    def realtimeMetricsSubscriptionConfig: Optional[
      zio.aws.cloudfront.model.RealtimeMetricsSubscriptionConfig.ReadOnly
    ]
    def getRealtimeMetricsSubscriptionConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.RealtimeMetricsSubscriptionConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "realtimeMetricsSubscriptionConfig",
      realtimeMetricsSubscriptionConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.MonitoringSubscription
  ) extends zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly {
    override val realtimeMetricsSubscriptionConfig: Optional[
      zio.aws.cloudfront.model.RealtimeMetricsSubscriptionConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.realtimeMetricsSubscriptionConfig())
      .map(value =>
        zio.aws.cloudfront.model.RealtimeMetricsSubscriptionConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.MonitoringSubscription
  ): zio.aws.cloudfront.model.MonitoringSubscription.ReadOnly = new Wrapper(
    impl
  )
}
