package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContinuousDeploymentPolicyConfigResponse(
    continuousDeploymentPolicyConfig: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig
    ] = Optional.Absent,
    eTag: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse = {
    import GetContinuousDeploymentPolicyConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse
      .builder()
      .optionallyWith(
        continuousDeploymentPolicyConfig.map(value => value.buildAwsValue())
      )(_.continuousDeploymentPolicyConfig)
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse.ReadOnly =
    zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse
      .wrap(buildAwsValue())
}
object GetContinuousDeploymentPolicyConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse =
      zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse(
        continuousDeploymentPolicyConfig.map(value => value.asEditable),
        eTag.map(value => value)
      )
    def continuousDeploymentPolicyConfig: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly
    ]
    def eTag: Optional[String]
    def getContinuousDeploymentPolicyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "continuousDeploymentPolicyConfig",
      continuousDeploymentPolicyConfig
    )
    def getETag: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("eTag", eTag)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse
  ) extends zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse.ReadOnly {
    override val continuousDeploymentPolicyConfig: Optional[
      zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.continuousDeploymentPolicyConfig())
      .map(value =>
        zio.aws.cloudfront.model.ContinuousDeploymentPolicyConfig.wrap(value)
      )
    override val eTag: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.eTag())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse
  ): zio.aws.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse.ReadOnly =
    new Wrapper(impl)
}
