package zio.aws.cloudfront.model
import scala.jdk.CollectionConverters._
sealed trait CachePolicyCookieBehavior {
  def unwrap: software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior
}
object CachePolicyCookieBehavior {
  def wrap(
      value: software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior
  ): zio.aws.cloudfront.model.CachePolicyCookieBehavior = value match {
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.NONE =>
      val r = none
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.WHITELIST =>
      val r = whitelist
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.ALL_EXCEPT =>
      val r = allExcept
      r
    case software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.ALL =>
      val r = all
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudfront.model.CachePolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object none extends zio.aws.cloudfront.model.CachePolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.NONE
  }
  case object whitelist
      extends zio.aws.cloudfront.model.CachePolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.WHITELIST
  }
  case object allExcept
      extends zio.aws.cloudfront.model.CachePolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.ALL_EXCEPT
  }
  case object all extends zio.aws.cloudfront.model.CachePolicyCookieBehavior {
    override def unwrap
        : software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior =
      software.amazon.awssdk.services.cloudfront.model.CachePolicyCookieBehavior.ALL
  }
}
