package zio.aws.cloudfront.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.cloudfront.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Invalidation(
    id: String,
    status: String,
    createTime: Timestamp,
    invalidationBatch: zio.aws.cloudfront.model.InvalidationBatch
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudfront.model.Invalidation = {
    import Invalidation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudfront.model.Invalidation
      .builder()
      .id(id: java.lang.String)
      .status(status: java.lang.String)
      .createTime(Timestamp.unwrap(createTime): Instant)
      .invalidationBatch(invalidationBatch.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.cloudfront.model.Invalidation.ReadOnly =
    zio.aws.cloudfront.model.Invalidation.wrap(buildAwsValue())
}
object Invalidation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudfront.model.Invalidation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudfront.model.Invalidation =
      zio.aws.cloudfront.model.Invalidation(
        id,
        status,
        createTime,
        invalidationBatch.asEditable
      )
    def id: String
    def status: String
    def createTime: Timestamp
    def invalidationBatch: zio.aws.cloudfront.model.InvalidationBatch.ReadOnly
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getStatus: ZIO[Any, Nothing, String] = ZIO.succeed(status)
    def getCreateTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createTime)
    def getInvalidationBatch: ZIO[
      Any,
      Nothing,
      zio.aws.cloudfront.model.InvalidationBatch.ReadOnly
    ] = ZIO.succeed(invalidationBatch)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudfront.model.Invalidation
  ) extends zio.aws.cloudfront.model.Invalidation.ReadOnly {
    override val id: String = impl.id(): String
    override val status: String = impl.status(): String
    override val createTime: Timestamp =
      zio.aws.cloudfront.model.primitives.Timestamp(impl.createTime())
    override val invalidationBatch
        : zio.aws.cloudfront.model.InvalidationBatch.ReadOnly =
      zio.aws.cloudfront.model.InvalidationBatch.wrap(impl.invalidationBatch())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudfront.model.Invalidation
  ): zio.aws.cloudfront.model.Invalidation.ReadOnly = new Wrapper(impl)
}
