package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackPolicyDuringUpdateURL,
  TemplateURL,
  DisableRollback,
  StackPolicyDuringUpdateBody,
  StackName,
  NotificationARN,
  ClientRequestToken,
  StackPolicyBody,
  UsePreviousTemplate,
  ResourceType,
  RoleARN,
  StackPolicyURL,
  TemplateBody,
  RetainExceptOnCreate
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStackRequest(
    stackName: StackName,
    templateBody: Optional[TemplateBody] = Optional.Absent,
    templateURL: Optional[TemplateURL] = Optional.Absent,
    usePreviousTemplate: Optional[UsePreviousTemplate] = Optional.Absent,
    stackPolicyDuringUpdateBody: Optional[StackPolicyDuringUpdateBody] =
      Optional.Absent,
    stackPolicyDuringUpdateURL: Optional[StackPolicyDuringUpdateURL] =
      Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudformation.model.Parameter]] =
      Optional.Absent,
    capabilities: Optional[Iterable[zio.aws.cloudformation.model.Capability]] =
      Optional.Absent,
    resourceTypes: Optional[Iterable[ResourceType]] = Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    rollbackConfiguration: Optional[
      zio.aws.cloudformation.model.RollbackConfiguration
    ] = Optional.Absent,
    stackPolicyBody: Optional[StackPolicyBody] = Optional.Absent,
    stackPolicyURL: Optional[StackPolicyURL] = Optional.Absent,
    notificationARNs: Optional[Iterable[NotificationARN]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.cloudformation.model.Tag]] =
      Optional.Absent,
    disableRollback: Optional[DisableRollback] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    retainExceptOnCreate: Optional[RetainExceptOnCreate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest = {
    import UpdateStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        usePreviousTemplate.map(value =>
          UsePreviousTemplate.unwrap(value): java.lang.Boolean
        )
      )(_.usePreviousTemplate)
      .optionallyWith(
        stackPolicyDuringUpdateBody.map(value =>
          StackPolicyDuringUpdateBody.unwrap(value): java.lang.String
        )
      )(_.stackPolicyDuringUpdateBody)
      .optionallyWith(
        stackPolicyDuringUpdateURL.map(value =>
          StackPolicyDuringUpdateURL.unwrap(value): java.lang.String
        )
      )(_.stackPolicyDuringUpdateURL)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .optionallyWith(
        stackPolicyBody.map(value =>
          StackPolicyBody.unwrap(value): java.lang.String
        )
      )(_.stackPolicyBody)
      .optionallyWith(
        stackPolicyURL.map(value =>
          StackPolicyURL.unwrap(value): java.lang.String
        )
      )(_.stackPolicyURL)
      .optionallyWith(
        notificationARNs.map(value =>
          value.map { item =>
            NotificationARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationARNs)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        disableRollback.map(value =>
          DisableRollback.unwrap(value): java.lang.Boolean
        )
      )(_.disableRollback)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        retainExceptOnCreate.map(value =>
          RetainExceptOnCreate.unwrap(value): java.lang.Boolean
        )
      )(_.retainExceptOnCreate)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.UpdateStackRequest.ReadOnly =
    zio.aws.cloudformation.model.UpdateStackRequest.wrap(buildAwsValue())
}
object UpdateStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.UpdateStackRequest =
      zio.aws.cloudformation.model.UpdateStackRequest(
        stackName,
        templateBody.map(value => value),
        templateURL.map(value => value),
        usePreviousTemplate.map(value => value),
        stackPolicyDuringUpdateBody.map(value => value),
        stackPolicyDuringUpdateURL.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        capabilities.map(value => value),
        resourceTypes.map(value => value),
        roleARN.map(value => value),
        rollbackConfiguration.map(value => value.asEditable),
        stackPolicyBody.map(value => value),
        stackPolicyURL.map(value => value),
        notificationARNs.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableRollback.map(value => value),
        clientRequestToken.map(value => value),
        retainExceptOnCreate.map(value => value)
      )
    def stackName: StackName
    def templateBody: Optional[TemplateBody]
    def templateURL: Optional[TemplateURL]
    def usePreviousTemplate: Optional[UsePreviousTemplate]
    def stackPolicyDuringUpdateBody: Optional[StackPolicyDuringUpdateBody]
    def stackPolicyDuringUpdateURL: Optional[StackPolicyDuringUpdateURL]
    def parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def capabilities: Optional[List[zio.aws.cloudformation.model.Capability]]
    def resourceTypes: Optional[List[ResourceType]]
    def roleARN: Optional[RoleARN]
    def rollbackConfiguration
        : Optional[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly]
    def stackPolicyBody: Optional[StackPolicyBody]
    def stackPolicyURL: Optional[StackPolicyURL]
    def notificationARNs: Optional[List[NotificationARN]]
    def tags: Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def disableRollback: Optional[DisableRollback]
    def clientRequestToken: Optional[ClientRequestToken]
    def retainExceptOnCreate: Optional[RetainExceptOnCreate]
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getUsePreviousTemplate: ZIO[Any, AwsError, UsePreviousTemplate] =
      AwsError.unwrapOptionField("usePreviousTemplate", usePreviousTemplate)
    def getStackPolicyDuringUpdateBody
        : ZIO[Any, AwsError, StackPolicyDuringUpdateBody] =
      AwsError.unwrapOptionField(
        "stackPolicyDuringUpdateBody",
        stackPolicyDuringUpdateBody
      )
    def getStackPolicyDuringUpdateURL
        : ZIO[Any, AwsError, StackPolicyDuringUpdateURL] =
      AwsError.unwrapOptionField(
        "stackPolicyDuringUpdateURL",
        stackPolicyDuringUpdateURL
      )
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getResourceTypes: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getStackPolicyBody: ZIO[Any, AwsError, StackPolicyBody] =
      AwsError.unwrapOptionField("stackPolicyBody", stackPolicyBody)
    def getStackPolicyURL: ZIO[Any, AwsError, StackPolicyURL] =
      AwsError.unwrapOptionField("stackPolicyURL", stackPolicyURL)
    def getNotificationARNs: ZIO[Any, AwsError, List[NotificationARN]] =
      AwsError.unwrapOptionField("notificationARNs", notificationARNs)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDisableRollback: ZIO[Any, AwsError, DisableRollback] =
      AwsError.unwrapOptionField("disableRollback", disableRollback)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getRetainExceptOnCreate: ZIO[Any, AwsError, RetainExceptOnCreate] =
      AwsError.unwrapOptionField("retainExceptOnCreate", retainExceptOnCreate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest
  ) extends zio.aws.cloudformation.model.UpdateStackRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Optional[TemplateURL] = zio.aws.core.internal
      .optionalFromNullable(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val usePreviousTemplate: Optional[UsePreviousTemplate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.usePreviousTemplate())
        .map(value =>
          zio.aws.cloudformation.model.primitives.UsePreviousTemplate(value)
        )
    override val stackPolicyDuringUpdateBody
        : Optional[StackPolicyDuringUpdateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.stackPolicyDuringUpdateBody())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .StackPolicyDuringUpdateBody(value)
      )
    override val stackPolicyDuringUpdateURL
        : Optional[StackPolicyDuringUpdateURL] = zio.aws.core.internal
      .optionalFromNullable(impl.stackPolicyDuringUpdateURL())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .StackPolicyDuringUpdateURL(value)
      )
    override val parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Parameter.wrap(item)
          }.toList
        )
    override val capabilities
        : Optional[List[zio.aws.cloudformation.model.Capability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Capability.wrap(item)
          }.toList
        )
    override val resourceTypes: Optional[List[ResourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.ResourceType(item)
          }.toList
        )
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val rollbackConfiguration: Optional[
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackConfiguration())
      .map(value =>
        zio.aws.cloudformation.model.RollbackConfiguration.wrap(value)
      )
    override val stackPolicyBody: Optional[StackPolicyBody] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackPolicyBody())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackPolicyBody(value)
        )
    override val stackPolicyURL: Optional[StackPolicyURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackPolicyURL())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackPolicyURL(value)
        )
    override val notificationARNs: Optional[List[NotificationARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.NotificationARN(item)
          }.toList
        )
    override val tags
        : Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val disableRollback: Optional[DisableRollback] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableRollback())
        .map(value =>
          zio.aws.cloudformation.model.primitives.DisableRollback(value)
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
    override val retainExceptOnCreate: Optional[RetainExceptOnCreate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainExceptOnCreate())
        .map(value =>
          zio.aws.cloudformation.model.primitives.RetainExceptOnCreate(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.UpdateStackRequest
  ): zio.aws.cloudformation.model.UpdateStackRequest.ReadOnly = new Wrapper(
    impl
  )
}
