package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  TemplateURL,
  DisableRollback,
  StackName,
  NotificationARN,
  ClientRequestToken,
  StackPolicyBody,
  ResourceType,
  RoleARN,
  EnableTerminationProtection,
  StackPolicyURL,
  TimeoutMinutes,
  TemplateBody,
  RetainExceptOnCreate
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateStackRequest(
    stackName: StackName,
    templateBody: Optional[TemplateBody] = Optional.Absent,
    templateURL: Optional[TemplateURL] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudformation.model.Parameter]] =
      Optional.Absent,
    disableRollback: Optional[DisableRollback] = Optional.Absent,
    rollbackConfiguration: Optional[
      zio.aws.cloudformation.model.RollbackConfiguration
    ] = Optional.Absent,
    timeoutInMinutes: Optional[TimeoutMinutes] = Optional.Absent,
    notificationARNs: Optional[Iterable[NotificationARN]] = Optional.Absent,
    capabilities: Optional[Iterable[zio.aws.cloudformation.model.Capability]] =
      Optional.Absent,
    resourceTypes: Optional[Iterable[ResourceType]] = Optional.Absent,
    roleARN: Optional[RoleARN] = Optional.Absent,
    onFailure: Optional[zio.aws.cloudformation.model.OnFailure] =
      Optional.Absent,
    stackPolicyBody: Optional[StackPolicyBody] = Optional.Absent,
    stackPolicyURL: Optional[StackPolicyURL] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.cloudformation.model.Tag]] =
      Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    enableTerminationProtection: Optional[EnableTerminationProtection] =
      Optional.Absent,
    retainExceptOnCreate: Optional[RetainExceptOnCreate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CreateStackRequest = {
    import CreateStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CreateStackRequest
      .builder()
      .stackName(StackName.unwrap(stackName): java.lang.String)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        templateURL.map(value => TemplateURL.unwrap(value): java.lang.String)
      )(_.templateURL)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        disableRollback.map(value =>
          DisableRollback.unwrap(value): java.lang.Boolean
        )
      )(_.disableRollback)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .optionallyWith(
        timeoutInMinutes.map(value => TimeoutMinutes.unwrap(value): Integer)
      )(_.timeoutInMinutes)
      .optionallyWith(
        notificationARNs.map(value =>
          value.map { item =>
            NotificationARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationARNs)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        roleARN.map(value => RoleARN.unwrap(value): java.lang.String)
      )(_.roleARN)
      .optionallyWith(onFailure.map(value => value.unwrap))(_.onFailure)
      .optionallyWith(
        stackPolicyBody.map(value =>
          StackPolicyBody.unwrap(value): java.lang.String
        )
      )(_.stackPolicyBody)
      .optionallyWith(
        stackPolicyURL.map(value =>
          StackPolicyURL.unwrap(value): java.lang.String
        )
      )(_.stackPolicyURL)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        enableTerminationProtection.map(value =>
          EnableTerminationProtection.unwrap(value): java.lang.Boolean
        )
      )(_.enableTerminationProtection)
      .optionallyWith(
        retainExceptOnCreate.map(value =>
          RetainExceptOnCreate.unwrap(value): java.lang.Boolean
        )
      )(_.retainExceptOnCreate)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.CreateStackRequest.ReadOnly =
    zio.aws.cloudformation.model.CreateStackRequest.wrap(buildAwsValue())
}
object CreateStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CreateStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CreateStackRequest =
      zio.aws.cloudformation.model.CreateStackRequest(
        stackName,
        templateBody.map(value => value),
        templateURL.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        disableRollback.map(value => value),
        rollbackConfiguration.map(value => value.asEditable),
        timeoutInMinutes.map(value => value),
        notificationARNs.map(value => value),
        capabilities.map(value => value),
        resourceTypes.map(value => value),
        roleARN.map(value => value),
        onFailure.map(value => value),
        stackPolicyBody.map(value => value),
        stackPolicyURL.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientRequestToken.map(value => value),
        enableTerminationProtection.map(value => value),
        retainExceptOnCreate.map(value => value)
      )
    def stackName: StackName
    def templateBody: Optional[TemplateBody]
    def templateURL: Optional[TemplateURL]
    def parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def disableRollback: Optional[DisableRollback]
    def rollbackConfiguration
        : Optional[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly]
    def timeoutInMinutes: Optional[TimeoutMinutes]
    def notificationARNs: Optional[List[NotificationARN]]
    def capabilities: Optional[List[zio.aws.cloudformation.model.Capability]]
    def resourceTypes: Optional[List[ResourceType]]
    def roleARN: Optional[RoleARN]
    def onFailure: Optional[zio.aws.cloudformation.model.OnFailure]
    def stackPolicyBody: Optional[StackPolicyBody]
    def stackPolicyURL: Optional[StackPolicyURL]
    def tags: Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def clientRequestToken: Optional[ClientRequestToken]
    def enableTerminationProtection: Optional[EnableTerminationProtection]
    def retainExceptOnCreate: Optional[RetainExceptOnCreate]
    def getStackName: ZIO[Any, Nothing, StackName] = ZIO.succeed(stackName)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getTemplateURL: ZIO[Any, AwsError, TemplateURL] =
      AwsError.unwrapOptionField("templateURL", templateURL)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getDisableRollback: ZIO[Any, AwsError, DisableRollback] =
      AwsError.unwrapOptionField("disableRollback", disableRollback)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getTimeoutInMinutes: ZIO[Any, AwsError, TimeoutMinutes] =
      AwsError.unwrapOptionField("timeoutInMinutes", timeoutInMinutes)
    def getNotificationARNs: ZIO[Any, AwsError, List[NotificationARN]] =
      AwsError.unwrapOptionField("notificationARNs", notificationARNs)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getResourceTypes: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getRoleARN: ZIO[Any, AwsError, RoleARN] =
      AwsError.unwrapOptionField("roleARN", roleARN)
    def getOnFailure
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.OnFailure] =
      AwsError.unwrapOptionField("onFailure", onFailure)
    def getStackPolicyBody: ZIO[Any, AwsError, StackPolicyBody] =
      AwsError.unwrapOptionField("stackPolicyBody", stackPolicyBody)
    def getStackPolicyURL: ZIO[Any, AwsError, StackPolicyURL] =
      AwsError.unwrapOptionField("stackPolicyURL", stackPolicyURL)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getEnableTerminationProtection
        : ZIO[Any, AwsError, EnableTerminationProtection] =
      AwsError.unwrapOptionField(
        "enableTerminationProtection",
        enableTerminationProtection
      )
    def getRetainExceptOnCreate: ZIO[Any, AwsError, RetainExceptOnCreate] =
      AwsError.unwrapOptionField("retainExceptOnCreate", retainExceptOnCreate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackRequest
  ) extends zio.aws.cloudformation.model.CreateStackRequest.ReadOnly {
    override val stackName: StackName =
      zio.aws.cloudformation.model.primitives.StackName(impl.stackName())
    override val templateBody: Optional[TemplateBody] = zio.aws.core.internal
      .optionalFromNullable(impl.templateBody())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateBody(value))
    override val templateURL: Optional[TemplateURL] = zio.aws.core.internal
      .optionalFromNullable(impl.templateURL())
      .map(value => zio.aws.cloudformation.model.primitives.TemplateURL(value))
    override val parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Parameter.wrap(item)
          }.toList
        )
    override val disableRollback: Optional[DisableRollback] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableRollback())
        .map(value =>
          zio.aws.cloudformation.model.primitives.DisableRollback(value)
        )
    override val rollbackConfiguration: Optional[
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackConfiguration())
      .map(value =>
        zio.aws.cloudformation.model.RollbackConfiguration.wrap(value)
      )
    override val timeoutInMinutes: Optional[TimeoutMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInMinutes())
        .map(value =>
          zio.aws.cloudformation.model.primitives.TimeoutMinutes(value)
        )
    override val notificationARNs: Optional[List[NotificationARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.NotificationARN(item)
          }.toList
        )
    override val capabilities
        : Optional[List[zio.aws.cloudformation.model.Capability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Capability.wrap(item)
          }.toList
        )
    override val resourceTypes: Optional[List[ResourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.ResourceType(item)
          }.toList
        )
    override val roleARN: Optional[RoleARN] = zio.aws.core.internal
      .optionalFromNullable(impl.roleARN())
      .map(value => zio.aws.cloudformation.model.primitives.RoleARN(value))
    override val onFailure: Optional[zio.aws.cloudformation.model.OnFailure] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onFailure())
        .map(value => zio.aws.cloudformation.model.OnFailure.wrap(value))
    override val stackPolicyBody: Optional[StackPolicyBody] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackPolicyBody())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackPolicyBody(value)
        )
    override val stackPolicyURL: Optional[StackPolicyURL] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackPolicyURL())
        .map(value =>
          zio.aws.cloudformation.model.primitives.StackPolicyURL(value)
        )
    override val tags
        : Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
    override val enableTerminationProtection
        : Optional[EnableTerminationProtection] = zio.aws.core.internal
      .optionalFromNullable(impl.enableTerminationProtection())
      .map(value =>
        zio.aws.cloudformation.model.primitives
          .EnableTerminationProtection(value)
      )
    override val retainExceptOnCreate: Optional[RetainExceptOnCreate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainExceptOnCreate())
        .map(value =>
          zio.aws.cloudformation.model.primitives.RetainExceptOnCreate(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackRequest
  ): zio.aws.cloudformation.model.CreateStackRequest.ReadOnly = new Wrapper(
    impl
  )
}
