package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  Timestamp,
  Description,
  StackSetId,
  StackSetName
}
import scala.jdk.CollectionConverters._
final case class StackSetSummary(
    stackSetName: Optional[StackSetName] = Optional.Absent,
    stackSetId: Optional[StackSetId] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    status: Optional[zio.aws.cloudformation.model.StackSetStatus] =
      Optional.Absent,
    autoDeployment: Optional[zio.aws.cloudformation.model.AutoDeployment] =
      Optional.Absent,
    permissionModel: Optional[zio.aws.cloudformation.model.PermissionModels] =
      Optional.Absent,
    driftStatus: Optional[zio.aws.cloudformation.model.StackDriftStatus] =
      Optional.Absent,
    lastDriftCheckTimestamp: Optional[Timestamp] = Optional.Absent,
    managedExecution: Optional[zio.aws.cloudformation.model.ManagedExecution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackSetSummary = {
    import StackSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackSetSummary
      .builder()
      .optionallyWith(
        stackSetName.map(value => StackSetName.unwrap(value): java.lang.String)
      )(_.stackSetName)
      .optionallyWith(
        stackSetId.map(value => StackSetId.unwrap(value): java.lang.String)
      )(_.stackSetId)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(autoDeployment.map(value => value.buildAwsValue()))(
        _.autoDeployment
      )
      .optionallyWith(permissionModel.map(value => value.unwrap))(
        _.permissionModel
      )
      .optionallyWith(driftStatus.map(value => value.unwrap))(_.driftStatus)
      .optionallyWith(
        lastDriftCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDriftCheckTimestamp)
      .optionallyWith(managedExecution.map(value => value.buildAwsValue()))(
        _.managedExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackSetSummary.ReadOnly =
    zio.aws.cloudformation.model.StackSetSummary.wrap(buildAwsValue())
}
object StackSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackSetSummary =
      zio.aws.cloudformation.model.StackSetSummary(
        stackSetName.map(value => value),
        stackSetId.map(value => value),
        description.map(value => value),
        status.map(value => value),
        autoDeployment.map(value => value.asEditable),
        permissionModel.map(value => value),
        driftStatus.map(value => value),
        lastDriftCheckTimestamp.map(value => value),
        managedExecution.map(value => value.asEditable)
      )
    def stackSetName: Optional[StackSetName]
    def stackSetId: Optional[StackSetId]
    def description: Optional[Description]
    def status: Optional[zio.aws.cloudformation.model.StackSetStatus]
    def autoDeployment
        : Optional[zio.aws.cloudformation.model.AutoDeployment.ReadOnly]
    def permissionModel: Optional[zio.aws.cloudformation.model.PermissionModels]
    def driftStatus: Optional[zio.aws.cloudformation.model.StackDriftStatus]
    def lastDriftCheckTimestamp: Optional[Timestamp]
    def managedExecution
        : Optional[zio.aws.cloudformation.model.ManagedExecution.ReadOnly]
    def getStackSetName: ZIO[Any, AwsError, StackSetName] =
      AwsError.unwrapOptionField("stackSetName", stackSetName)
    def getStackSetId: ZIO[Any, AwsError, StackSetId] =
      AwsError.unwrapOptionField("stackSetId", stackSetId)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getAutoDeployment: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.AutoDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("autoDeployment", autoDeployment)
    def getPermissionModel
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.PermissionModels] =
      AwsError.unwrapOptionField("permissionModel", permissionModel)
    def getDriftStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackDriftStatus] =
      AwsError.unwrapOptionField("driftStatus", driftStatus)
    def getLastDriftCheckTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDriftCheckTimestamp", lastDriftCheckTimestamp)
    def getManagedExecution: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.ManagedExecution.ReadOnly
    ] = AwsError.unwrapOptionField("managedExecution", managedExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetSummary
  ) extends zio.aws.cloudformation.model.StackSetSummary.ReadOnly {
    override val stackSetName: Optional[StackSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetName())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetName(value))
    override val stackSetId: Optional[StackSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetId())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetId(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val status: Optional[zio.aws.cloudformation.model.StackSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.cloudformation.model.StackSetStatus.wrap(value))
    override val autoDeployment
        : Optional[zio.aws.cloudformation.model.AutoDeployment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoDeployment())
        .map(value => zio.aws.cloudformation.model.AutoDeployment.wrap(value))
    override val permissionModel
        : Optional[zio.aws.cloudformation.model.PermissionModels] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionModel())
        .map(value => zio.aws.cloudformation.model.PermissionModels.wrap(value))
    override val driftStatus
        : Optional[zio.aws.cloudformation.model.StackDriftStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driftStatus())
        .map(value => zio.aws.cloudformation.model.StackDriftStatus.wrap(value))
    override val lastDriftCheckTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDriftCheckTimestamp())
        .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val managedExecution
        : Optional[zio.aws.cloudformation.model.ManagedExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedExecution())
        .map(value => zio.aws.cloudformation.model.ManagedExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackSetSummary
  ): zio.aws.cloudformation.model.StackSetSummary.ReadOnly = new Wrapper(impl)
}
