package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TransformName,
  CapabilitiesReason,
  ResourceType,
  Description,
  Version,
  Metadata
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTemplateSummaryResponse(
    parameters: Optional[
      Iterable[zio.aws.cloudformation.model.ParameterDeclaration]
    ] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    capabilities: Optional[Iterable[zio.aws.cloudformation.model.Capability]] =
      Optional.Absent,
    capabilitiesReason: Optional[CapabilitiesReason] = Optional.Absent,
    resourceTypes: Optional[Iterable[ResourceType]] = Optional.Absent,
    version: Optional[Version] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    declaredTransforms: Optional[Iterable[TransformName]] = Optional.Absent,
    resourceIdentifierSummaries: Optional[
      Iterable[zio.aws.cloudformation.model.ResourceIdentifierSummary]
    ] = Optional.Absent,
    warnings: Optional[zio.aws.cloudformation.model.Warnings] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse = {
    import GetTemplateSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        capabilitiesReason.map(value =>
          CapabilitiesReason.unwrap(value): java.lang.String
        )
      )(_.capabilitiesReason)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            ResourceType.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypes)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(
        declaredTransforms.map(value =>
          value.map { item =>
            TransformName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.declaredTransforms)
      .optionallyWith(
        resourceIdentifierSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIdentifierSummaries)
      .optionallyWith(warnings.map(value => value.buildAwsValue()))(_.warnings)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly =
    zio.aws.cloudformation.model.GetTemplateSummaryResponse
      .wrap(buildAwsValue())
}
object GetTemplateSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.GetTemplateSummaryResponse =
      zio.aws.cloudformation.model.GetTemplateSummaryResponse(
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        capabilities.map(value => value),
        capabilitiesReason.map(value => value),
        resourceTypes.map(value => value),
        version.map(value => value),
        metadata.map(value => value),
        declaredTransforms.map(value => value),
        resourceIdentifierSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        warnings.map(value => value.asEditable)
      )
    def parameters: Optional[
      List[zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly]
    ]
    def description: Optional[Description]
    def capabilities: Optional[List[zio.aws.cloudformation.model.Capability]]
    def capabilitiesReason: Optional[CapabilitiesReason]
    def resourceTypes: Optional[List[ResourceType]]
    def version: Optional[Version]
    def metadata: Optional[Metadata]
    def declaredTransforms: Optional[List[TransformName]]
    def resourceIdentifierSummaries: Optional[
      List[zio.aws.cloudformation.model.ResourceIdentifierSummary.ReadOnly]
    ]
    def warnings: Optional[zio.aws.cloudformation.model.Warnings.ReadOnly]
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getCapabilitiesReason: ZIO[Any, AwsError, CapabilitiesReason] =
      AwsError.unwrapOptionField("capabilitiesReason", capabilitiesReason)
    def getResourceTypes: ZIO[Any, AwsError, List[ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getDeclaredTransforms: ZIO[Any, AwsError, List[TransformName]] =
      AwsError.unwrapOptionField("declaredTransforms", declaredTransforms)
    def getResourceIdentifierSummaries: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.ResourceIdentifierSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "resourceIdentifierSummaries",
      resourceIdentifierSummaries
    )
    def getWarnings
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.Warnings.ReadOnly] =
      AwsError.unwrapOptionField("warnings", warnings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse
  ) extends zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly {
    override val parameters: Optional[
      List[zio.aws.cloudformation.model.ParameterDeclaration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.ParameterDeclaration.wrap(item)
        }.toList
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val capabilities
        : Optional[List[zio.aws.cloudformation.model.Capability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Capability.wrap(item)
          }.toList
        )
    override val capabilitiesReason: Optional[CapabilitiesReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilitiesReason())
        .map(value =>
          zio.aws.cloudformation.model.primitives.CapabilitiesReason(value)
        )
    override val resourceTypes: Optional[List[ResourceType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.ResourceType(item)
          }.toList
        )
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.cloudformation.model.primitives.Version(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.cloudformation.model.primitives.Metadata(value))
    override val declaredTransforms: Optional[List[TransformName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.declaredTransforms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.TransformName(item)
          }.toList
        )
    override val resourceIdentifierSummaries: Optional[
      List[zio.aws.cloudformation.model.ResourceIdentifierSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIdentifierSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.ResourceIdentifierSummary.wrap(item)
        }.toList
      )
    override val warnings
        : Optional[zio.aws.cloudformation.model.Warnings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnings())
        .map(value => zio.aws.cloudformation.model.Warnings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.GetTemplateSummaryResponse
  ): zio.aws.cloudformation.model.GetTemplateSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
