package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  StackNameOrId,
  DisableRollback,
  ChangeSetNameOrId,
  ClientRequestToken,
  RetainExceptOnCreate
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExecuteChangeSetRequest(
    changeSetName: ChangeSetNameOrId,
    stackName: Optional[StackNameOrId] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    disableRollback: Optional[DisableRollback] = Optional.Absent,
    retainExceptOnCreate: Optional[RetainExceptOnCreate] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest = {
    import ExecuteChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest
      .builder()
      .changeSetName(ChangeSetNameOrId.unwrap(changeSetName): java.lang.String)
      .optionallyWith(
        stackName.map(value => StackNameOrId.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        disableRollback.map(value =>
          DisableRollback.unwrap(value): java.lang.Boolean
        )
      )(_.disableRollback)
      .optionallyWith(
        retainExceptOnCreate.map(value =>
          RetainExceptOnCreate.unwrap(value): java.lang.Boolean
        )
      )(_.retainExceptOnCreate)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.ExecuteChangeSetRequest.ReadOnly =
    zio.aws.cloudformation.model.ExecuteChangeSetRequest.wrap(buildAwsValue())
}
object ExecuteChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ExecuteChangeSetRequest =
      zio.aws.cloudformation.model.ExecuteChangeSetRequest(
        changeSetName,
        stackName.map(value => value),
        clientRequestToken.map(value => value),
        disableRollback.map(value => value),
        retainExceptOnCreate.map(value => value)
      )
    def changeSetName: ChangeSetNameOrId
    def stackName: Optional[StackNameOrId]
    def clientRequestToken: Optional[ClientRequestToken]
    def disableRollback: Optional[DisableRollback]
    def retainExceptOnCreate: Optional[RetainExceptOnCreate]
    def getChangeSetName: ZIO[Any, Nothing, ChangeSetNameOrId] =
      ZIO.succeed(changeSetName)
    def getStackName: ZIO[Any, AwsError, StackNameOrId] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDisableRollback: ZIO[Any, AwsError, DisableRollback] =
      AwsError.unwrapOptionField("disableRollback", disableRollback)
    def getRetainExceptOnCreate: ZIO[Any, AwsError, RetainExceptOnCreate] =
      AwsError.unwrapOptionField("retainExceptOnCreate", retainExceptOnCreate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest
  ) extends zio.aws.cloudformation.model.ExecuteChangeSetRequest.ReadOnly {
    override val changeSetName: ChangeSetNameOrId =
      zio.aws.cloudformation.model.primitives
        .ChangeSetNameOrId(impl.changeSetName())
    override val stackName: Optional[StackNameOrId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StackNameOrId(value)
      )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
    override val disableRollback: Optional[DisableRollback] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableRollback())
        .map(value =>
          zio.aws.cloudformation.model.primitives.DisableRollback(value)
        )
    override val retainExceptOnCreate: Optional[RetainExceptOnCreate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainExceptOnCreate())
        .map(value =>
          zio.aws.cloudformation.model.primitives.RetainExceptOnCreate(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest
  ): zio.aws.cloudformation.model.ExecuteChangeSetRequest.ReadOnly =
    new Wrapper(impl)
}
