package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeOrganizationsAccessResponse(
    status: Optional[zio.aws.cloudformation.model.OrganizationStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessResponse = {
    import DescribeOrganizationsAccessResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeOrganizationsAccessResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeOrganizationsAccessResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationsAccessResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeOrganizationsAccessResponse =
      zio.aws.cloudformation.model
        .DescribeOrganizationsAccessResponse(status.map(value => value))
    def status: Optional[zio.aws.cloudformation.model.OrganizationStatus]
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.OrganizationStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessResponse
  ) extends zio.aws.cloudformation.model.DescribeOrganizationsAccessResponse.ReadOnly {
    override val status
        : Optional[zio.aws.cloudformation.model.OrganizationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.cloudformation.model.OrganizationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeOrganizationsAccessResponse
  ): zio.aws.cloudformation.model.DescribeOrganizationsAccessResponse.ReadOnly =
    new Wrapper(impl)
}
