package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  CreationTime,
  NextToken,
  ChangeSetName,
  StackName,
  NotificationARN,
  IncludeNestedStacks,
  StackId,
  Description,
  ChangeSetId,
  ChangeSetStatusReason
}
import scala.jdk.CollectionConverters._
final case class DescribeChangeSetResponse(
    changeSetName: Optional[ChangeSetName] = Optional.Absent,
    changeSetId: Optional[ChangeSetId] = Optional.Absent,
    stackId: Optional[StackId] = Optional.Absent,
    stackName: Optional[StackName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    parameters: Optional[Iterable[zio.aws.cloudformation.model.Parameter]] =
      Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    executionStatus: Optional[zio.aws.cloudformation.model.ExecutionStatus] =
      Optional.Absent,
    status: Optional[zio.aws.cloudformation.model.ChangeSetStatus] =
      Optional.Absent,
    statusReason: Optional[ChangeSetStatusReason] = Optional.Absent,
    notificationARNs: Optional[Iterable[NotificationARN]] = Optional.Absent,
    rollbackConfiguration: Optional[
      zio.aws.cloudformation.model.RollbackConfiguration
    ] = Optional.Absent,
    capabilities: Optional[Iterable[zio.aws.cloudformation.model.Capability]] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.cloudformation.model.Tag]] =
      Optional.Absent,
    changes: Optional[Iterable[zio.aws.cloudformation.model.Change]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    includeNestedStacks: Optional[IncludeNestedStacks] = Optional.Absent,
    parentChangeSetId: Optional[ChangeSetId] = Optional.Absent,
    rootChangeSetId: Optional[ChangeSetId] = Optional.Absent,
    onStackFailure: Optional[zio.aws.cloudformation.model.OnStackFailure] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse = {
    import DescribeChangeSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse
      .builder()
      .optionallyWith(
        changeSetName.map(value =>
          ChangeSetName.unwrap(value): java.lang.String
        )
      )(_.changeSetName)
      .optionallyWith(
        changeSetId.map(value => ChangeSetId.unwrap(value): java.lang.String)
      )(_.changeSetId)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        stackName.map(value => StackName.unwrap(value): java.lang.String)
      )(_.stackName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(executionStatus.map(value => value.unwrap))(
        _.executionStatus
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          ChangeSetStatusReason.unwrap(value): java.lang.String
        )
      )(_.statusReason)
      .optionallyWith(
        notificationARNs.map(value =>
          value.map { item =>
            NotificationARN.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.notificationARNs)
      .optionallyWith(
        rollbackConfiguration.map(value => value.buildAwsValue())
      )(_.rollbackConfiguration)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        changes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.changes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        includeNestedStacks.map(value =>
          IncludeNestedStacks.unwrap(value): java.lang.Boolean
        )
      )(_.includeNestedStacks)
      .optionallyWith(
        parentChangeSetId.map(value =>
          ChangeSetId.unwrap(value): java.lang.String
        )
      )(_.parentChangeSetId)
      .optionallyWith(
        rootChangeSetId.map(value =>
          ChangeSetId.unwrap(value): java.lang.String
        )
      )(_.rootChangeSetId)
      .optionallyWith(onStackFailure.map(value => value.unwrap))(
        _.onStackFailure
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeChangeSetResponse.wrap(buildAwsValue())
}
object DescribeChangeSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeChangeSetResponse =
      zio.aws.cloudformation.model.DescribeChangeSetResponse(
        changeSetName.map(value => value),
        changeSetId.map(value => value),
        stackId.map(value => value),
        stackName.map(value => value),
        description.map(value => value),
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        executionStatus.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        notificationARNs.map(value => value),
        rollbackConfiguration.map(value => value.asEditable),
        capabilities.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        changes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        includeNestedStacks.map(value => value),
        parentChangeSetId.map(value => value),
        rootChangeSetId.map(value => value),
        onStackFailure.map(value => value)
      )
    def changeSetName: Optional[ChangeSetName]
    def changeSetId: Optional[ChangeSetId]
    def stackId: Optional[StackId]
    def stackName: Optional[StackName]
    def description: Optional[Description]
    def parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def creationTime: Optional[CreationTime]
    def executionStatus: Optional[zio.aws.cloudformation.model.ExecutionStatus]
    def status: Optional[zio.aws.cloudformation.model.ChangeSetStatus]
    def statusReason: Optional[ChangeSetStatusReason]
    def notificationARNs: Optional[List[NotificationARN]]
    def rollbackConfiguration
        : Optional[zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly]
    def capabilities: Optional[List[zio.aws.cloudformation.model.Capability]]
    def tags: Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]]
    def changes: Optional[List[zio.aws.cloudformation.model.Change.ReadOnly]]
    def nextToken: Optional[NextToken]
    def includeNestedStacks: Optional[IncludeNestedStacks]
    def parentChangeSetId: Optional[ChangeSetId]
    def rootChangeSetId: Optional[ChangeSetId]
    def onStackFailure: Optional[zio.aws.cloudformation.model.OnStackFailure]
    def getChangeSetName: ZIO[Any, AwsError, ChangeSetName] =
      AwsError.unwrapOptionField("changeSetName", changeSetName)
    def getChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("changeSetId", changeSetId)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStackName: ZIO[Any, AwsError, StackName] =
      AwsError.unwrapOptionField("stackName", stackName)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getExecutionStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ExecutionStatus] =
      AwsError.unwrapOptionField("executionStatus", executionStatus)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.ChangeSetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, ChangeSetStatusReason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getNotificationARNs: ZIO[Any, AwsError, List[NotificationARN]] =
      AwsError.unwrapOptionField("notificationARNs", notificationARNs)
    def getRollbackConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("rollbackConfiguration", rollbackConfiguration)
    def getCapabilities
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Capability]] =
      AwsError.unwrapOptionField("capabilities", capabilities)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getChanges: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Change.ReadOnly
    ]] = AwsError.unwrapOptionField("changes", changes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIncludeNestedStacks: ZIO[Any, AwsError, IncludeNestedStacks] =
      AwsError.unwrapOptionField("includeNestedStacks", includeNestedStacks)
    def getParentChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("parentChangeSetId", parentChangeSetId)
    def getRootChangeSetId: ZIO[Any, AwsError, ChangeSetId] =
      AwsError.unwrapOptionField("rootChangeSetId", rootChangeSetId)
    def getOnStackFailure
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.OnStackFailure] =
      AwsError.unwrapOptionField("onStackFailure", onStackFailure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse
  ) extends zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly {
    override val changeSetName: Optional[ChangeSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.changeSetName())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ChangeSetName(value)
      )
    override val changeSetId: Optional[ChangeSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.changeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val stackId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val stackName: Optional[StackName] = zio.aws.core.internal
      .optionalFromNullable(impl.stackName())
      .map(value => zio.aws.cloudformation.model.primitives.StackName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.cloudformation.model.primitives.Description(value))
    override val parameters
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Parameter.wrap(item)
          }.toList
        )
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.cloudformation.model.primitives.CreationTime(value))
    override val executionStatus
        : Optional[zio.aws.cloudformation.model.ExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionStatus())
        .map(value => zio.aws.cloudformation.model.ExecutionStatus.wrap(value))
    override val status
        : Optional[zio.aws.cloudformation.model.ChangeSetStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.cloudformation.model.ChangeSetStatus.wrap(value))
    override val statusReason: Optional[ChangeSetStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ChangeSetStatusReason(value)
        )
    override val notificationARNs: Optional[List[NotificationARN]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationARNs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.primitives.NotificationARN(item)
          }.toList
        )
    override val rollbackConfiguration: Optional[
      zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackConfiguration())
      .map(value =>
        zio.aws.cloudformation.model.RollbackConfiguration.wrap(value)
      )
    override val capabilities
        : Optional[List[zio.aws.cloudformation.model.Capability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Capability.wrap(item)
          }.toList
        )
    override val tags
        : Optional[List[zio.aws.cloudformation.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Tag.wrap(item)
          }.toList
        )
    override val changes
        : Optional[List[zio.aws.cloudformation.model.Change.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Change.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.cloudformation.model.primitives.NextToken(value))
    override val includeNestedStacks: Optional[IncludeNestedStacks] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeNestedStacks())
        .map(value =>
          zio.aws.cloudformation.model.primitives.IncludeNestedStacks(value)
        )
    override val parentChangeSetId: Optional[ChangeSetId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentChangeSetId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ChangeSetId(value)
        )
    override val rootChangeSetId: Optional[ChangeSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.rootChangeSetId())
      .map(value => zio.aws.cloudformation.model.primitives.ChangeSetId(value))
    override val onStackFailure
        : Optional[zio.aws.cloudformation.model.OnStackFailure] =
      zio.aws.core.internal
        .optionalFromNullable(impl.onStackFailure())
        .map(value => zio.aws.cloudformation.model.OnStackFailure.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetResponse
  ): zio.aws.cloudformation.model.DescribeChangeSetResponse.ReadOnly =
    new Wrapper(impl)
}
