package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.TreatUnrecognizedResourceTypesAsWarnings
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TemplateSummaryConfig(
    treatUnrecognizedResourceTypesAsWarnings: Optional[
      TreatUnrecognizedResourceTypesAsWarnings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.TemplateSummaryConfig = {
    import TemplateSummaryConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.TemplateSummaryConfig
      .builder()
      .optionallyWith(
        treatUnrecognizedResourceTypesAsWarnings.map(value =>
          TreatUnrecognizedResourceTypesAsWarnings.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.treatUnrecognizedResourceTypesAsWarnings)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.TemplateSummaryConfig.ReadOnly =
    zio.aws.cloudformation.model.TemplateSummaryConfig.wrap(buildAwsValue())
}
object TemplateSummaryConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.TemplateSummaryConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.TemplateSummaryConfig =
      zio.aws.cloudformation.model.TemplateSummaryConfig(
        treatUnrecognizedResourceTypesAsWarnings.map(value => value)
      )
    def treatUnrecognizedResourceTypesAsWarnings
        : Optional[TreatUnrecognizedResourceTypesAsWarnings]
    def getTreatUnrecognizedResourceTypesAsWarnings
        : ZIO[Any, AwsError, TreatUnrecognizedResourceTypesAsWarnings] =
      AwsError.unwrapOptionField(
        "treatUnrecognizedResourceTypesAsWarnings",
        treatUnrecognizedResourceTypesAsWarnings
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.TemplateSummaryConfig
  ) extends zio.aws.cloudformation.model.TemplateSummaryConfig.ReadOnly {
    override val treatUnrecognizedResourceTypesAsWarnings
        : Optional[TreatUnrecognizedResourceTypesAsWarnings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.treatUnrecognizedResourceTypesAsWarnings())
        .map(value =>
          zio.aws.cloudformation.model.primitives
            .TreatUnrecognizedResourceTypesAsWarnings(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.TemplateSummaryConfig
  ): zio.aws.cloudformation.model.TemplateSummaryConfig.ReadOnly = new Wrapper(
    impl
  )
}
