package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ResourceIdentifierPropertyValue,
  ResourceIdentifierPropertyKey,
  LogicalResourceId,
  ResourceType
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ResourceToImport(
    resourceType: ResourceType,
    logicalResourceId: LogicalResourceId,
    resourceIdentifier: Map[
      ResourceIdentifierPropertyKey,
      ResourceIdentifierPropertyValue
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.ResourceToImport = {
    import ResourceToImport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.ResourceToImport
      .builder()
      .resourceType(ResourceType.unwrap(resourceType): java.lang.String)
      .logicalResourceId(
        LogicalResourceId.unwrap(logicalResourceId): java.lang.String
      )
      .resourceIdentifier(
        resourceIdentifier
          .map({ case (key, value) =>
            (ResourceIdentifierPropertyKey.unwrap(
              key
            ): java.lang.String) -> (ResourceIdentifierPropertyValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.ResourceToImport.ReadOnly =
    zio.aws.cloudformation.model.ResourceToImport.wrap(buildAwsValue())
}
object ResourceToImport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.ResourceToImport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.ResourceToImport =
      zio.aws.cloudformation.model
        .ResourceToImport(resourceType, logicalResourceId, resourceIdentifier)
    def resourceType: ResourceType
    def logicalResourceId: LogicalResourceId
    def resourceIdentifier
        : Map[ResourceIdentifierPropertyKey, ResourceIdentifierPropertyValue]
    def getResourceType: ZIO[Any, Nothing, ResourceType] =
      ZIO.succeed(resourceType)
    def getLogicalResourceId: ZIO[Any, Nothing, LogicalResourceId] =
      ZIO.succeed(logicalResourceId)
    def getResourceIdentifier: ZIO[Any, Nothing, Map[
      ResourceIdentifierPropertyKey,
      ResourceIdentifierPropertyValue
    ]] = ZIO.succeed(resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceToImport
  ) extends zio.aws.cloudformation.model.ResourceToImport.ReadOnly {
    override val resourceType: ResourceType =
      zio.aws.cloudformation.model.primitives.ResourceType(impl.resourceType())
    override val logicalResourceId: LogicalResourceId =
      zio.aws.cloudformation.model.primitives
        .LogicalResourceId(impl.logicalResourceId())
    override val resourceIdentifier
        : Map[ResourceIdentifierPropertyKey, ResourceIdentifierPropertyValue] =
      impl
        .resourceIdentifier()
        .asScala
        .map({ case (key, value) =>
          zio.aws.cloudformation.model.primitives.ResourceIdentifierPropertyKey(
            key
          ) -> zio.aws.cloudformation.model.primitives
            .ResourceIdentifierPropertyValue(value)
        })
        .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.ResourceToImport
  ): zio.aws.cloudformation.model.ResourceToImport.ReadOnly = new Wrapper(impl)
}
