package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ConnectionArn,
  AcceptTermsAndConditions
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterPublisherRequest(
    acceptTermsAndConditions: Optional[AcceptTermsAndConditions] =
      Optional.Absent,
    connectionArn: Optional[ConnectionArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest = {
    import RegisterPublisherRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest
      .builder()
      .optionallyWith(
        acceptTermsAndConditions.map(value =>
          AcceptTermsAndConditions.unwrap(value): java.lang.Boolean
        )
      )(_.acceptTermsAndConditions)
      .optionallyWith(
        connectionArn.map(value =>
          ConnectionArn.unwrap(value): java.lang.String
        )
      )(_.connectionArn)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.RegisterPublisherRequest.ReadOnly =
    zio.aws.cloudformation.model.RegisterPublisherRequest.wrap(buildAwsValue())
}
object RegisterPublisherRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RegisterPublisherRequest =
      zio.aws.cloudformation.model.RegisterPublisherRequest(
        acceptTermsAndConditions.map(value => value),
        connectionArn.map(value => value)
      )
    def acceptTermsAndConditions: Optional[AcceptTermsAndConditions]
    def connectionArn: Optional[ConnectionArn]
    def getAcceptTermsAndConditions
        : ZIO[Any, AwsError, AcceptTermsAndConditions] = AwsError
      .unwrapOptionField("acceptTermsAndConditions", acceptTermsAndConditions)
    def getConnectionArn: ZIO[Any, AwsError, ConnectionArn] =
      AwsError.unwrapOptionField("connectionArn", connectionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest
  ) extends zio.aws.cloudformation.model.RegisterPublisherRequest.ReadOnly {
    override val acceptTermsAndConditions: Optional[AcceptTermsAndConditions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceptTermsAndConditions())
        .map(value =>
          zio.aws.cloudformation.model.primitives
            .AcceptTermsAndConditions(value)
        )
    override val connectionArn: Optional[ConnectionArn] = zio.aws.core.internal
      .optionalFromNullable(impl.connectionArn())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ConnectionArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RegisterPublisherRequest
  ): zio.aws.cloudformation.model.RegisterPublisherRequest.ReadOnly =
    new Wrapper(impl)
}
