package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  ResourceModel,
  StatusMessage,
  ClientToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RecordHandlerProgressRequest(
    bearerToken: ClientToken,
    operationStatus: zio.aws.cloudformation.model.OperationStatus,
    currentOperationStatus: Optional[
      zio.aws.cloudformation.model.OperationStatus
    ] = Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    errorCode: Optional[zio.aws.cloudformation.model.HandlerErrorCode] =
      Optional.Absent,
    resourceModel: Optional[ResourceModel] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest = {
    import RecordHandlerProgressRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest
      .builder()
      .bearerToken(ClientToken.unwrap(bearerToken): java.lang.String)
      .operationStatus(operationStatus.unwrap)
      .optionallyWith(currentOperationStatus.map(value => value.unwrap))(
        _.currentOperationStatus
      )
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        resourceModel.map(value =>
          ResourceModel.unwrap(value): java.lang.String
        )
      )(_.resourceModel)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.RecordHandlerProgressRequest.ReadOnly =
    zio.aws.cloudformation.model.RecordHandlerProgressRequest
      .wrap(buildAwsValue())
}
object RecordHandlerProgressRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RecordHandlerProgressRequest =
      zio.aws.cloudformation.model.RecordHandlerProgressRequest(
        bearerToken,
        operationStatus,
        currentOperationStatus.map(value => value),
        statusMessage.map(value => value),
        errorCode.map(value => value),
        resourceModel.map(value => value),
        clientRequestToken.map(value => value)
      )
    def bearerToken: ClientToken
    def operationStatus: zio.aws.cloudformation.model.OperationStatus
    def currentOperationStatus
        : Optional[zio.aws.cloudformation.model.OperationStatus]
    def statusMessage: Optional[StatusMessage]
    def errorCode: Optional[zio.aws.cloudformation.model.HandlerErrorCode]
    def resourceModel: Optional[ResourceModel]
    def clientRequestToken: Optional[ClientRequestToken]
    def getBearerToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(bearerToken)
    def getOperationStatus
        : ZIO[Any, Nothing, zio.aws.cloudformation.model.OperationStatus] =
      ZIO.succeed(operationStatus)
    def getCurrentOperationStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.OperationStatus] =
      AwsError.unwrapOptionField(
        "currentOperationStatus",
        currentOperationStatus
      )
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.HandlerErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getResourceModel: ZIO[Any, AwsError, ResourceModel] =
      AwsError.unwrapOptionField("resourceModel", resourceModel)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest
  ) extends zio.aws.cloudformation.model.RecordHandlerProgressRequest.ReadOnly {
    override val bearerToken: ClientToken =
      zio.aws.cloudformation.model.primitives.ClientToken(impl.bearerToken())
    override val operationStatus: zio.aws.cloudformation.model.OperationStatus =
      zio.aws.cloudformation.model.OperationStatus.wrap(impl.operationStatus())
    override val currentOperationStatus
        : Optional[zio.aws.cloudformation.model.OperationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentOperationStatus())
        .map(value => zio.aws.cloudformation.model.OperationStatus.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.cloudformation.model.primitives.StatusMessage(value)
      )
    override val errorCode
        : Optional[zio.aws.cloudformation.model.HandlerErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.cloudformation.model.HandlerErrorCode.wrap(value))
    override val resourceModel: Optional[ResourceModel] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceModel())
      .map(value =>
        zio.aws.cloudformation.model.primitives.ResourceModel(value)
      )
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RecordHandlerProgressRequest
  ): zio.aws.cloudformation.model.RecordHandlerProgressRequest.ReadOnly =
    new Wrapper(impl)
}
