package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackDriftDetectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DetectStackDriftResponse(
    stackDriftDetectionId: StackDriftDetectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse = {
    import DetectStackDriftResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse
      .builder()
      .stackDriftDetectionId(
        StackDriftDetectionId.unwrap(stackDriftDetectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DetectStackDriftResponse.ReadOnly =
    zio.aws.cloudformation.model.DetectStackDriftResponse.wrap(buildAwsValue())
}
object DetectStackDriftResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DetectStackDriftResponse =
      zio.aws.cloudformation.model
        .DetectStackDriftResponse(stackDriftDetectionId)
    def stackDriftDetectionId: StackDriftDetectionId
    def getStackDriftDetectionId: ZIO[Any, Nothing, StackDriftDetectionId] =
      ZIO.succeed(stackDriftDetectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse
  ) extends zio.aws.cloudformation.model.DetectStackDriftResponse.ReadOnly {
    override val stackDriftDetectionId: StackDriftDetectionId =
      zio.aws.cloudformation.model.primitives
        .StackDriftDetectionId(impl.stackDriftDetectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DetectStackDriftResponse
  ): zio.aws.cloudformation.model.DetectStackDriftResponse.ReadOnly =
    new Wrapper(impl)
}
