package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  TypeVersionId,
  PublisherId,
  PublicVersionNumber,
  TypeArn,
  TypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeTypeRequest(
    `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      Optional.Absent,
    typeName: Optional[TypeName] = Optional.Absent,
    arn: Optional[TypeArn] = Optional.Absent,
    versionId: Optional[TypeVersionId] = Optional.Absent,
    publisherId: Optional[PublisherId] = Optional.Absent,
    publicVersionNumber: Optional[PublicVersionNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest = {
    import DescribeTypeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        typeName.map(value => TypeName.unwrap(value): java.lang.String)
      )(_.typeName)
      .optionallyWith(
        arn.map(value => TypeArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        versionId.map(value => TypeVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        publisherId.map(value => PublisherId.unwrap(value): java.lang.String)
      )(_.publisherId)
      .optionallyWith(
        publicVersionNumber.map(value =>
          PublicVersionNumber.unwrap(value): java.lang.String
        )
      )(_.publicVersionNumber)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.DescribeTypeRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeTypeRequest.wrap(buildAwsValue())
}
object DescribeTypeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeTypeRequest =
      zio.aws.cloudformation.model.DescribeTypeRequest(
        `type`.map(value => value),
        typeName.map(value => value),
        arn.map(value => value),
        versionId.map(value => value),
        publisherId.map(value => value),
        publicVersionNumber.map(value => value)
      )
    def `type`: Optional[zio.aws.cloudformation.model.RegistryType]
    def typeName: Optional[TypeName]
    def arn: Optional[TypeArn]
    def versionId: Optional[TypeVersionId]
    def publisherId: Optional[PublisherId]
    def publicVersionNumber: Optional[PublicVersionNumber]
    def getType: ZIO[Any, AwsError, zio.aws.cloudformation.model.RegistryType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTypeName: ZIO[Any, AwsError, TypeName] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getArn: ZIO[Any, AwsError, TypeArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getVersionId: ZIO[Any, AwsError, TypeVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getPublisherId: ZIO[Any, AwsError, PublisherId] =
      AwsError.unwrapOptionField("publisherId", publisherId)
    def getPublicVersionNumber: ZIO[Any, AwsError, PublicVersionNumber] =
      AwsError.unwrapOptionField("publicVersionNumber", publicVersionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest
  ) extends zio.aws.cloudformation.model.DescribeTypeRequest.ReadOnly {
    override val `type`: Optional[zio.aws.cloudformation.model.RegistryType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.cloudformation.model.RegistryType.wrap(value))
    override val typeName: Optional[TypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.typeName())
      .map(value => zio.aws.cloudformation.model.primitives.TypeName(value))
    override val arn: Optional[TypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.cloudformation.model.primitives.TypeArn(value))
    override val versionId: Optional[TypeVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value =>
        zio.aws.cloudformation.model.primitives.TypeVersionId(value)
      )
    override val publisherId: Optional[PublisherId] = zio.aws.core.internal
      .optionalFromNullable(impl.publisherId())
      .map(value => zio.aws.cloudformation.model.primitives.PublisherId(value))
    override val publicVersionNumber: Optional[PublicVersionNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publicVersionNumber())
        .map(value =>
          zio.aws.cloudformation.model.primitives.PublicVersionNumber(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeTypeRequest
  ): zio.aws.cloudformation.model.DescribeTypeRequest.ReadOnly = new Wrapper(
    impl
  )
}
