package zio.aws.cloudformation.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStackInstanceResponse(
    stackInstance: Optional[zio.aws.cloudformation.model.StackInstance] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse = {
    import DescribeStackInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse
      .builder()
      .optionallyWith(stackInstance.map(value => value.buildAwsValue()))(
        _.stackInstance
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackInstanceResponse.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackInstanceResponse
      .wrap(buildAwsValue())
}
object DescribeStackInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.DescribeStackInstanceResponse =
      zio.aws.cloudformation.model.DescribeStackInstanceResponse(
        stackInstance.map(value => value.asEditable)
      )
    def stackInstance
        : Optional[zio.aws.cloudformation.model.StackInstance.ReadOnly]
    def getStackInstance: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackInstance.ReadOnly
    ] = AwsError.unwrapOptionField("stackInstance", stackInstance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse
  ) extends zio.aws.cloudformation.model.DescribeStackInstanceResponse.ReadOnly {
    override val stackInstance
        : Optional[zio.aws.cloudformation.model.StackInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stackInstance())
        .map(value => zio.aws.cloudformation.model.StackInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackInstanceResponse
  ): zio.aws.cloudformation.model.DescribeStackInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
