package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait TemplateStage {
  def unwrap: software.amazon.awssdk.services.cloudformation.model.TemplateStage
}
object TemplateStage {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.TemplateStage
  ): zio.aws.cloudformation.model.TemplateStage = value match {
    case software.amazon.awssdk.services.cloudformation.model.TemplateStage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.TemplateStage.ORIGINAL =>
      val r = Original
      r
    case software.amazon.awssdk.services.cloudformation.model.TemplateStage.PROCESSED =>
      val r = Processed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.TemplateStage {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.TemplateStage =
      software.amazon.awssdk.services.cloudformation.model.TemplateStage.UNKNOWN_TO_SDK_VERSION
  }
  case object Original extends zio.aws.cloudformation.model.TemplateStage {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.TemplateStage =
      software.amazon.awssdk.services.cloudformation.model.TemplateStage.ORIGINAL
  }
  case object Processed extends zio.aws.cloudformation.model.TemplateStage {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.TemplateStage =
      software.amazon.awssdk.services.cloudformation.model.TemplateStage.PROCESSED
  }
}
