package zio.aws.cloudformation.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.MonitoringTimeInMinutes
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RollbackConfiguration(
    rollbackTriggers: Optional[
      Iterable[zio.aws.cloudformation.model.RollbackTrigger]
    ] = Optional.Absent,
    monitoringTimeInMinutes: Optional[MonitoringTimeInMinutes] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration = {
    import RollbackConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration
      .builder()
      .optionallyWith(
        rollbackTriggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rollbackTriggers)
      .optionallyWith(
        monitoringTimeInMinutes.map(value =>
          MonitoringTimeInMinutes.unwrap(value): Integer
        )
      )(_.monitoringTimeInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly =
    zio.aws.cloudformation.model.RollbackConfiguration.wrap(buildAwsValue())
}
object RollbackConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.RollbackConfiguration =
      zio.aws.cloudformation.model.RollbackConfiguration(
        rollbackTriggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        monitoringTimeInMinutes.map(value => value)
      )
    def rollbackTriggers
        : Optional[List[zio.aws.cloudformation.model.RollbackTrigger.ReadOnly]]
    def monitoringTimeInMinutes: Optional[MonitoringTimeInMinutes]
    def getRollbackTriggers: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.RollbackTrigger.ReadOnly
    ]] = AwsError.unwrapOptionField("rollbackTriggers", rollbackTriggers)
    def getMonitoringTimeInMinutes
        : ZIO[Any, AwsError, MonitoringTimeInMinutes] = AwsError
      .unwrapOptionField("monitoringTimeInMinutes", monitoringTimeInMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration
  ) extends zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly {
    override val rollbackTriggers: Optional[
      List[zio.aws.cloudformation.model.RollbackTrigger.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.rollbackTriggers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.RollbackTrigger.wrap(item)
        }.toList
      )
    override val monitoringTimeInMinutes: Optional[MonitoringTimeInMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.monitoringTimeInMinutes())
        .map(value =>
          zio.aws.cloudformation.model.primitives.MonitoringTimeInMinutes(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.RollbackConfiguration
  ): zio.aws.cloudformation.model.RollbackConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
