package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait HandlerErrorCode {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode
}
object HandlerErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode
  ): zio.aws.cloudformation.model.HandlerErrorCode = value match {
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NOT_UPDATABLE =>
      val r = NotUpdatable
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INVALID_REQUEST =>
      val r = InvalidRequest
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.ACCESS_DENIED =>
      val r = AccessDenied
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INVALID_CREDENTIALS =>
      val r = InvalidCredentials
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.ALREADY_EXISTS =>
      val r = AlreadyExists
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NOT_FOUND =>
      val r = NotFound
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.RESOURCE_CONFLICT =>
      val r = ResourceConflict
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.THROTTLING =>
      val r = Throttling
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.SERVICE_LIMIT_EXCEEDED =>
      val r = ServiceLimitExceeded
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NOT_STABILIZED =>
      val r = NotStabilized
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.GENERAL_SERVICE_EXCEPTION =>
      val r = GeneralServiceException
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.SERVICE_INTERNAL_ERROR =>
      val r = ServiceInternalError
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NETWORK_FAILURE =>
      val r = NetworkFailure
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INTERNAL_FAILURE =>
      val r = InternalFailure
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INVALID_TYPE_CONFIGURATION =>
      val r = InvalidTypeConfiguration
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.HANDLER_INTERNAL_FAILURE =>
      val r = HandlerInternalFailure
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NON_COMPLIANT =>
      val r = NonCompliant
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.UNKNOWN =>
      val r = Unknown
      r
    case software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.UNSUPPORTED_TARGET =>
      val r = UnsupportedTarget
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object NotUpdatable
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NOT_UPDATABLE
  }
  case object InvalidRequest
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INVALID_REQUEST
  }
  case object AccessDenied
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.ACCESS_DENIED
  }
  case object InvalidCredentials
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INVALID_CREDENTIALS
  }
  case object AlreadyExists
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.ALREADY_EXISTS
  }
  case object NotFound extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NOT_FOUND
  }
  case object ResourceConflict
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.RESOURCE_CONFLICT
  }
  case object Throttling extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.THROTTLING
  }
  case object ServiceLimitExceeded
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.SERVICE_LIMIT_EXCEEDED
  }
  case object NotStabilized
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NOT_STABILIZED
  }
  case object GeneralServiceException
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.GENERAL_SERVICE_EXCEPTION
  }
  case object ServiceInternalError
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.SERVICE_INTERNAL_ERROR
  }
  case object NetworkFailure
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NETWORK_FAILURE
  }
  case object InternalFailure
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INTERNAL_FAILURE
  }
  case object InvalidTypeConfiguration
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.INVALID_TYPE_CONFIGURATION
  }
  case object HandlerInternalFailure
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.HANDLER_INTERNAL_FAILURE
  }
  case object NonCompliant
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.NON_COMPLIANT
  }
  case object Unknown extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.UNKNOWN
  }
  case object UnsupportedTarget
      extends zio.aws.cloudformation.model.HandlerErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode =
      software.amazon.awssdk.services.cloudformation.model.HandlerErrorCode.UNSUPPORTED_TARGET
  }
}
