package zio.aws.cloudformation.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.cloudformation.model.primitives.{
  Account,
  Timestamp,
  ClientRequestToken,
  StackSetId,
  StackId,
  Region,
  OrganizationalUnitId,
  Reason
}
import scala.jdk.CollectionConverters._
final case class StackInstanceSummary(
    stackSetId: Optional[StackSetId] = Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    account: Optional[Account] = Optional.Absent,
    stackId: Optional[StackId] = Optional.Absent,
    status: Optional[zio.aws.cloudformation.model.StackInstanceStatus] =
      Optional.Absent,
    statusReason: Optional[Reason] = Optional.Absent,
    stackInstanceStatus: Optional[
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus
    ] = Optional.Absent,
    organizationalUnitId: Optional[OrganizationalUnitId] = Optional.Absent,
    driftStatus: Optional[zio.aws.cloudformation.model.StackDriftStatus] =
      Optional.Absent,
    lastDriftCheckTimestamp: Optional[Timestamp] = Optional.Absent,
    lastOperationId: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.StackInstanceSummary = {
    import StackInstanceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.StackInstanceSummary
      .builder()
      .optionallyWith(
        stackSetId.map(value => StackSetId.unwrap(value): java.lang.String)
      )(_.stackSetId)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        account.map(value => Account.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.statusReason)
      .optionallyWith(stackInstanceStatus.map(value => value.buildAwsValue()))(
        _.stackInstanceStatus
      )
      .optionallyWith(
        organizationalUnitId.map(value =>
          OrganizationalUnitId.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitId)
      .optionallyWith(driftStatus.map(value => value.unwrap))(_.driftStatus)
      .optionallyWith(
        lastDriftCheckTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastDriftCheckTimestamp)
      .optionallyWith(
        lastOperationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.lastOperationId)
      .build()
  }
  def asReadOnly: zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly =
    zio.aws.cloudformation.model.StackInstanceSummary.wrap(buildAwsValue())
}
object StackInstanceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.StackInstanceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.StackInstanceSummary =
      zio.aws.cloudformation.model.StackInstanceSummary(
        stackSetId.map(value => value),
        region.map(value => value),
        account.map(value => value),
        stackId.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        stackInstanceStatus.map(value => value.asEditable),
        organizationalUnitId.map(value => value),
        driftStatus.map(value => value),
        lastDriftCheckTimestamp.map(value => value),
        lastOperationId.map(value => value)
      )
    def stackSetId: Optional[StackSetId]
    def region: Optional[Region]
    def account: Optional[Account]
    def stackId: Optional[StackId]
    def status: Optional[zio.aws.cloudformation.model.StackInstanceStatus]
    def statusReason: Optional[Reason]
    def stackInstanceStatus: Optional[
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly
    ]
    def organizationalUnitId: Optional[OrganizationalUnitId]
    def driftStatus: Optional[zio.aws.cloudformation.model.StackDriftStatus]
    def lastDriftCheckTimestamp: Optional[Timestamp]
    def lastOperationId: Optional[ClientRequestToken]
    def getStackSetId: ZIO[Any, AwsError, StackSetId] =
      AwsError.unwrapOptionField("stackSetId", stackSetId)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getAccount: ZIO[Any, AwsError, Account] =
      AwsError.unwrapOptionField("account", account)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackInstanceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getStackInstanceStatus: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly
    ] = AwsError.unwrapOptionField("stackInstanceStatus", stackInstanceStatus)
    def getOrganizationalUnitId: ZIO[Any, AwsError, OrganizationalUnitId] =
      AwsError.unwrapOptionField("organizationalUnitId", organizationalUnitId)
    def getDriftStatus
        : ZIO[Any, AwsError, zio.aws.cloudformation.model.StackDriftStatus] =
      AwsError.unwrapOptionField("driftStatus", driftStatus)
    def getLastDriftCheckTimestamp: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastDriftCheckTimestamp", lastDriftCheckTimestamp)
    def getLastOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("lastOperationId", lastOperationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstanceSummary
  ) extends zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly {
    override val stackSetId: Optional[StackSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackSetId())
      .map(value => zio.aws.cloudformation.model.primitives.StackSetId(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.cloudformation.model.primitives.Region(value))
    override val account: Optional[Account] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.cloudformation.model.primitives.Account(value))
    override val stackId: Optional[StackId] = zio.aws.core.internal
      .optionalFromNullable(impl.stackId())
      .map(value => zio.aws.cloudformation.model.primitives.StackId(value))
    override val status
        : Optional[zio.aws.cloudformation.model.StackInstanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.cloudformation.model.StackInstanceStatus.wrap(value)
        )
    override val statusReason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => zio.aws.cloudformation.model.primitives.Reason(value))
    override val stackInstanceStatus: Optional[
      zio.aws.cloudformation.model.StackInstanceComprehensiveStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.stackInstanceStatus())
      .map(value =>
        zio.aws.cloudformation.model.StackInstanceComprehensiveStatus
          .wrap(value)
      )
    override val organizationalUnitId: Optional[OrganizationalUnitId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.organizationalUnitId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.OrganizationalUnitId(value)
        )
    override val driftStatus
        : Optional[zio.aws.cloudformation.model.StackDriftStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driftStatus())
        .map(value => zio.aws.cloudformation.model.StackDriftStatus.wrap(value))
    override val lastDriftCheckTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastDriftCheckTimestamp())
        .map(value => zio.aws.cloudformation.model.primitives.Timestamp(value))
    override val lastOperationId: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastOperationId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.StackInstanceSummary
  ): zio.aws.cloudformation.model.StackInstanceSummary.ReadOnly = new Wrapper(
    impl
  )
}
