package zio.aws.cloudformation.model
import scala.jdk.CollectionConverters._
sealed trait IdentityProvider {
  def unwrap
      : software.amazon.awssdk.services.cloudformation.model.IdentityProvider
}
object IdentityProvider {
  def wrap(
      value: software.amazon.awssdk.services.cloudformation.model.IdentityProvider
  ): zio.aws.cloudformation.model.IdentityProvider = value match {
    case software.amazon.awssdk.services.cloudformation.model.IdentityProvider.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.cloudformation.model.IdentityProvider.AWS_MARKETPLACE =>
      val r = AWS_Marketplace
      r
    case software.amazon.awssdk.services.cloudformation.model.IdentityProvider.GIT_HUB =>
      val r = GitHub
      r
    case software.amazon.awssdk.services.cloudformation.model.IdentityProvider.BITBUCKET =>
      val r = Bitbucket
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.cloudformation.model.IdentityProvider {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.IdentityProvider =
      software.amazon.awssdk.services.cloudformation.model.IdentityProvider.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_Marketplace
      extends zio.aws.cloudformation.model.IdentityProvider {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.IdentityProvider =
      software.amazon.awssdk.services.cloudformation.model.IdentityProvider.AWS_MARKETPLACE
  }
  case object GitHub extends zio.aws.cloudformation.model.IdentityProvider {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.IdentityProvider =
      software.amazon.awssdk.services.cloudformation.model.IdentityProvider.GIT_HUB
  }
  case object Bitbucket extends zio.aws.cloudformation.model.IdentityProvider {
    override def unwrap
        : software.amazon.awssdk.services.cloudformation.model.IdentityProvider =
      software.amazon.awssdk.services.cloudformation.model.IdentityProvider.BITBUCKET
  }
}
