package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.StackDriftDetectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStackDriftDetectionStatusRequest(
    stackDriftDetectionId: StackDriftDetectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest = {
    import DescribeStackDriftDetectionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest
      .builder()
      .stackDriftDetectionId(
        StackDriftDetectionId.unwrap(stackDriftDetectionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusRequest.ReadOnly =
    zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusRequest
      .wrap(buildAwsValue())
}
object DescribeStackDriftDetectionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusRequest =
      zio.aws.cloudformation.model
        .DescribeStackDriftDetectionStatusRequest(stackDriftDetectionId)
    def stackDriftDetectionId: StackDriftDetectionId
    def getStackDriftDetectionId: ZIO[Any, Nothing, StackDriftDetectionId] =
      ZIO.succeed(stackDriftDetectionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest
  ) extends zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusRequest.ReadOnly {
    override val stackDriftDetectionId: StackDriftDetectionId =
      zio.aws.cloudformation.model.primitives
        .StackDriftDetectionId(impl.stackDriftDetectionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.DescribeStackDriftDetectionStatusRequest
  ): zio.aws.cloudformation.model.DescribeStackDriftDetectionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
