package zio.aws.cloudformation.model
import zio.aws.cloudformation.model.primitives.{
  ClientRequestToken,
  Region,
  Account,
  StackSetName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStackInstancesRequest(
    stackSetName: StackSetName,
    accounts: Optional[Iterable[Account]] = Optional.Absent,
    deploymentTargets: Optional[
      zio.aws.cloudformation.model.DeploymentTargets
    ] = Optional.Absent,
    regions: Iterable[Region],
    parameterOverrides: Optional[
      Iterable[zio.aws.cloudformation.model.Parameter]
    ] = Optional.Absent,
    operationPreferences: Optional[
      zio.aws.cloudformation.model.StackSetOperationPreferences
    ] = Optional.Absent,
    operationId: Optional[ClientRequestToken] = Optional.Absent,
    callAs: Optional[zio.aws.cloudformation.model.CallAs] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest = {
    import CreateStackInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest
      .builder()
      .stackSetName(StackSetName.unwrap(stackSetName): java.lang.String)
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            Account.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(deploymentTargets.map(value => value.buildAwsValue()))(
        _.deploymentTargets
      )
      .regions(regions.map { item =>
        Region.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        parameterOverrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameterOverrides)
      .optionallyWith(operationPreferences.map(value => value.buildAwsValue()))(
        _.operationPreferences
      )
      .optionallyWith(
        operationId.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.operationId)
      .optionallyWith(callAs.map(value => value.unwrap))(_.callAs)
      .build()
  }
  def asReadOnly
      : zio.aws.cloudformation.model.CreateStackInstancesRequest.ReadOnly =
    zio.aws.cloudformation.model.CreateStackInstancesRequest
      .wrap(buildAwsValue())
}
object CreateStackInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.cloudformation.model.CreateStackInstancesRequest =
      zio.aws.cloudformation.model.CreateStackInstancesRequest(
        stackSetName,
        accounts.map(value => value),
        deploymentTargets.map(value => value.asEditable),
        regions,
        parameterOverrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        operationPreferences.map(value => value.asEditable),
        operationId.map(value => value),
        callAs.map(value => value)
      )
    def stackSetName: StackSetName
    def accounts: Optional[List[Account]]
    def deploymentTargets
        : Optional[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly]
    def regions: List[Region]
    def parameterOverrides
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]]
    def operationPreferences: Optional[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ]
    def operationId: Optional[ClientRequestToken]
    def callAs: Optional[zio.aws.cloudformation.model.CallAs]
    def getStackSetName: ZIO[Any, Nothing, StackSetName] =
      ZIO.succeed(stackSetName)
    def getAccounts: ZIO[Any, AwsError, List[Account]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getDeploymentTargets: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.DeploymentTargets.ReadOnly
    ] = AwsError.unwrapOptionField("deploymentTargets", deploymentTargets)
    def getRegions: ZIO[Any, Nothing, List[Region]] = ZIO.succeed(regions)
    def getParameterOverrides: ZIO[Any, AwsError, List[
      zio.aws.cloudformation.model.Parameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameterOverrides", parameterOverrides)
    def getOperationPreferences: ZIO[
      Any,
      AwsError,
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = AwsError.unwrapOptionField("operationPreferences", operationPreferences)
    def getOperationId: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("operationId", operationId)
    def getCallAs: ZIO[Any, AwsError, zio.aws.cloudformation.model.CallAs] =
      AwsError.unwrapOptionField("callAs", callAs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest
  ) extends zio.aws.cloudformation.model.CreateStackInstancesRequest.ReadOnly {
    override val stackSetName: StackSetName =
      zio.aws.cloudformation.model.primitives.StackSetName(impl.stackSetName())
    override val accounts: Optional[List[Account]] = zio.aws.core.internal
      .optionalFromNullable(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.cloudformation.model.primitives.Account(item)
        }.toList
      )
    override val deploymentTargets
        : Optional[zio.aws.cloudformation.model.DeploymentTargets.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentTargets())
        .map(value =>
          zio.aws.cloudformation.model.DeploymentTargets.wrap(value)
        )
    override val regions: List[Region] = impl
      .regions()
      .asScala
      .map { item =>
        zio.aws.cloudformation.model.primitives.Region(item)
      }
      .toList
    override val parameterOverrides
        : Optional[List[zio.aws.cloudformation.model.Parameter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameterOverrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.cloudformation.model.Parameter.wrap(item)
          }.toList
        )
    override val operationPreferences: Optional[
      zio.aws.cloudformation.model.StackSetOperationPreferences.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.operationPreferences())
      .map(value =>
        zio.aws.cloudformation.model.StackSetOperationPreferences.wrap(value)
      )
    override val operationId: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationId())
        .map(value =>
          zio.aws.cloudformation.model.primitives.ClientRequestToken(value)
        )
    override val callAs: Optional[zio.aws.cloudformation.model.CallAs] =
      zio.aws.core.internal
        .optionalFromNullable(impl.callAs())
        .map(value => zio.aws.cloudformation.model.CallAs.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest
  ): zio.aws.cloudformation.model.CreateStackInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
